package ar.com.sdd.interbanking.io.financiero;

import ar.com.sdd.interbanking.model.financiero.AccountBalance;
import ar.com.sdd.interbanking.model.financiero.GeneralData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BalanceResponse implements Serializable {

    @JsonProperty("general-data")
    private GeneralData generalData;

    @JsonProperty("accounts")
    private List<AccountBalance> accountsBalances;


    public GeneralData getGeneralData() {
        return generalData;
    }

    public void setGeneralData(GeneralData generalData) {
        this.generalData = generalData;
    }

    public List<AccountBalance> getAccountsBalances() {
        return accountsBalances;
    }

    public void setAccountsBalances(List<AccountBalance> accountsBalances) {
        this.accountsBalances = accountsBalances;
    }

    @Override
    public String toString() {
        return "SaldosResponse ["
                + ((generalData != null) ? "generalData=" + generalData + ", " : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BalanceResponse that = (BalanceResponse) o;
        return Objects.equals(generalData, that.generalData) && Objects.equals(accountsBalances, that.accountsBalances);
    }

    @Override
    public int hashCode() {
        return Objects.hash(generalData, accountsBalances);
    }
}