package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
/*
    "countable_balance": "<number>",
    "initial_operating_balance": "<number>",
    "current_operating_balance": "<number>",
    "projected_balance_24hs": "<number>",
    "projected_balance_48hs": "<number>"
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class Balance {

    @JsonProperty("countable_balance")
    private Double countableBalance;

    @JsonProperty("current_operating_balance")
    private Double currentOperatingBalance;

    @JsonProperty("initial_operating_balance")
    private Double initialOperatingBalance;

    @JsonProperty("projected_balance_24hs")
    private Double proyectedBalance24hs;

    @JsonProperty("projected_balance_48hs")
    private Double proyectedBalance48hs;

    public Double getCountableBalance() {
        return countableBalance;
    }

    public void setCountableBalance(Double countableBalance) {
        this.countableBalance = countableBalance;
    }

    public Double getCurrentOperatingBalance() {
        return currentOperatingBalance;
    }

    public void setCurrentOperatingBalance(Double currentOperatingBalance) {
        this.currentOperatingBalance = currentOperatingBalance;
    }

    public Double getInitialOperatingBalance() {
        return initialOperatingBalance;
    }

    public void setInitialOperatingBalance(Double initialOperatingBalance) {
        this.initialOperatingBalance = initialOperatingBalance;
    }

    public Double getProyectedBalance24hs() {
        return proyectedBalance24hs;
    }

    public void setProyectedBalance24hs(Double proyectedBalance24hs) {
        this.proyectedBalance24hs = proyectedBalance24hs;
    }

    public Double getProyectedBalance48hs() {
        return proyectedBalance48hs;
    }

    public void setProyectedBalance48hs(Double proyectedBalance48hs) {
        this.proyectedBalance48hs = proyectedBalance48hs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Balance balance = (Balance) o;

        if (!Objects.equals(countableBalance, balance.countableBalance)) return false;
        if (!Objects.equals(currentOperatingBalance, balance.currentOperatingBalance)) return false;
        if (!Objects.equals(initialOperatingBalance, balance.initialOperatingBalance)) return false;
        if (!Objects.equals(proyectedBalance24hs, balance.proyectedBalance24hs)) return false;
        return Objects.equals(proyectedBalance48hs, balance.proyectedBalance48hs);
    }

    @Override
    public int hashCode() {
        int result = countableBalance != null ? countableBalance.hashCode() : 0;
        result = 31 * result + (currentOperatingBalance != null ? currentOperatingBalance.hashCode() : 0);
        result = 31 * result + (initialOperatingBalance != null ? initialOperatingBalance.hashCode() : 0);
        result = 31 * result + (proyectedBalance24hs != null ? proyectedBalance24hs.hashCode() : 0);
        result = 31 * result + (proyectedBalance48hs != null ? proyectedBalance48hs.hashCode() : 0);
        return result;
    }
}