package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
/*
*
* {
    "bank_number": "string",
    "currency": "string",
    "account_number": "string",
    "control_code": "string",
    "page": 0,
    "limit": 0,
    "account_type": "string",
    "total_rows": 0
  }
*
* */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GeneralData {

    @JsonProperty("bank_number")
    private String bankNumber;// "517",
    @JsonProperty("currency")
    private String currency;// "$",

    @JsonProperty("account_type")
    private String accountType;// 2,

    @JsonProperty("account_number")
    private String accountNumber;// "0434149100",

    @JsonProperty("control_code")
    private String controlCode;// "123",

    @JsonProperty("page")
    private Integer page;//

    @JsonProperty("limit")
    private Integer limit;// 45

    @JsonProperty("total_rows")
    private Integer totalRows;// total registros devueos

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getControlCode() {
        return controlCode;
    }

    public void setControlCode(String controlCode) {
        this.controlCode = controlCode;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getTotalRows() {
        return totalRows;
    }

    public void setTotalRows(Integer totalRows) {
        this.totalRows = totalRows;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GeneralData that = (GeneralData) o;

        if (!Objects.equals(bankNumber, that.bankNumber)) return false;
        if (!Objects.equals(currency, that.currency)) return false;
        if (!Objects.equals(accountType, that.accountType)) return false;
        if (!Objects.equals(accountNumber, that.accountNumber)) return false;
        if (!Objects.equals(controlCode, that.controlCode)) return false;
        if (!Objects.equals(page, that.page)) return false;
        if (!Objects.equals(limit, that.limit)) return false;
        return Objects.equals(totalRows, that.totalRows);
    }

    @Override
    public int hashCode() {
        int result = bankNumber != null ? bankNumber.hashCode() : 0;
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (accountType != null ? accountType.hashCode() : 0);
        result = 31 * result + (accountNumber != null ? accountNumber.hashCode() : 0);
        result = 31 * result + (controlCode != null ? controlCode.hashCode() : 0);
        result = 31 * result + (page != null ? page.hashCode() : 0);
        result = 31 * result + (limit != null ? limit.hashCode() : 0);
        result = 31 * result + (totalRows != null ? totalRows.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GeneralData [" +
                "bankNumber=" + bankNumber +
                ", currency=" + currency +
                ", accountType=" + accountType +
                ", accountNumber=" + accountNumber +
                ", controlCode=" + controlCode +
                ", page=" + page +
                ", limit=" + limit +
                ", totalRows=" + totalRows +
                ']';
    }
}