package ar.com.sdd.interbanking.model.financiero_v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

/*
{
 "cliente": "X32085A",
 "razonSocial": "Reportes Financieros"
 }
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cliente {


    @JsonProperty("cliente")
    private String cliente;

    @JsonProperty("razonSocial")
    private String razonSocial;

    public String getCliente() {
        return cliente;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    @Override
    public String toString() {
        return "Cientes ["
                + ((cliente != null) ? "cliente=" + cliente + ", " : "")
                + ((razonSocial != null) ? "razonSocial=" + razonSocial + "" : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cliente that = (Cliente) o;
        return Objects.equals(cliente, that.cliente) && Objects.equals(razonSocial, that.razonSocial);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cliente, razonSocial);
    }
}