/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.interbanking.core.InterbankingApiBaseConnector;
import ar.com.sdd.interbanking.core.InterbankingApiCertificateConnectorContext;
import ar.com.sdd.interbanking.io.financiero_v1.ClientesResponse;
import ar.com.sdd.interbanking.io.financiero_v1.CuentasRequest;
import ar.com.sdd.interbanking.io.financiero_v1.CuentasResponse;
import ar.com.sdd.interbanking.io.financiero_v1.SaldosRequest;
import ar.com.sdd.interbanking.io.financiero_v1.SaldosResponse;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterbankingApiCertificateConnector
extends InterbankingApiBaseConnector {
    private static final Logger log = LogManager.getLogger(InterbankingApiCertificateConnector.class);
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;
    private String clientId;

    @Override
    public InterbankingApiBaseConnector.ConnectorClass getConnectorClass() {
        return InterbankingApiBaseConnector.ConnectorClass.CERTIFICATE;
    }

    public InterbankingApiCertificateConnector(InterbankingApiCertificateConnectorContext interbankingApiConnectorContext) {
        this.environment = new RestConnectorEnvironment(interbankingApiConnectorContext.getBaseUrl(), interbankingApiConnectorContext.getKeyStorePath(), interbankingApiConnectorContext.getKeyStorePassword(), interbankingApiConnectorContext.getTrustStorePath(), interbankingApiConnectorContext.getTrustStorePassword());
        this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
        log.debug("Creando connector InterbankingApiCertificate con [baseUrl='" + this.environment.baseUrl + "',clientId='" + this.clientId + "',keyStorePath='" + this.environment.keyStorePath + "']");
    }

    public ClientesResponse getClientes() throws RestConnectorException {
        log.debug("[getClientes] Request GET clientes");
        ClientesResponse response = (ClientesResponse)this.restConnector.genericGet(null, ClientesResponse.class, "/v1/clientes");
        log.debug("[getClientes] Response GET cientes [" + response + "]");
        return response;
    }

    public CuentasResponse getCuentas(String clientCode, CuentasRequest cuentasRequest) throws RestConnectorException {
        log.debug("[getCuentas] Request GET cuentas con clientCode [" + clientCode + "]");
        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/cuentas");
        Object requestParamsString = "";
        if (cuentasRequest.getBanco() != null && !"".equals(cuentasRequest.getBanco().trim())) {
            builder.add("banco", cuentasRequest.getBanco());
            requestParamsString = (String)requestParamsString + " banco [" + cuentasRequest.getBanco() + "]";
        }
        if (cuentasRequest.getNumeroCuenta() != null && !"".equals(cuentasRequest.getNumeroCuenta().trim())) {
            builder.add("numeroCuenta", cuentasRequest.getNumeroCuenta());
            requestParamsString = (String)requestParamsString + " numeroCuenta [" + cuentasRequest.getNumeroCuenta() + "]";
        }
        if (cuentasRequest.getTipo() != null && !"".equals(cuentasRequest.getTipo().trim())) {
            builder.add("tipo", cuentasRequest.getTipo());
            requestParamsString = (String)requestParamsString + " tipo [" + cuentasRequest.getTipo() + "]";
        }
        if (cuentasRequest.getMoneda() != null && !"".equals(cuentasRequest.getMoneda().trim())) {
            builder.add("moneda", cuentasRequest.getMoneda());
            requestParamsString = (String)requestParamsString + " moneda [" + cuentasRequest.getMoneda() + "]";
        }
        log.debug("[getSaldos] Request GET cuentas con " + (String)requestParamsString);
        CuentasResponse response = (CuentasResponse)this.restConnector.genericGet(null, CuentasResponse.class, builder.build(), "clientId", clientCode);
        log.debug("[getCuentas] Response GET cuentas [" + response + "]");
        return response;
    }

    public SaldosResponse getSaldos(String clientCode, SaldosRequest saldosRequest) throws RestConnectorException {
        log.debug("[getSaldos] Request GET saldos con clientCode [" + clientCode + "]");
        if (saldosRequest == null) {
            log.warn("[getSaldos] No se realiza la consulta de saldos porque saldosRequest es null");
            return null;
        }
        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/saldos");
        Object requestParamsString = "";
        if (saldosRequest.getBanco() == null || "".equals(saldosRequest.getBanco().trim())) {
            log.warn("[getSaldos] El codigo de banco es obligatorio para solicitar los saldos a IB");
            return null;
        }
        builder.add("banco", saldosRequest.getBanco());
        requestParamsString = (String)requestParamsString + " banco [" + saldosRequest.getBanco() + "]";
        if (saldosRequest.getNumeroCuenta() == null || "".equals(saldosRequest.getNumeroCuenta().trim())) {
            log.warn("[getSaldos] El numero de cuenta es obligatorio para solicitar los saldos a IB");
            return null;
        }
        builder.add("numeroCuenta", saldosRequest.getNumeroCuenta());
        requestParamsString = (String)requestParamsString + " numeroCuenta [" + saldosRequest.getNumeroCuenta() + "]";
        if (saldosRequest.getTipo() != null && !"".equals(saldosRequest.getTipo().trim())) {
            builder.add("tipo", saldosRequest.getTipo());
            requestParamsString = (String)requestParamsString + " tipo [" + saldosRequest.getTipo() + "]";
        }
        if (saldosRequest.getMoneda() != null && !"".equals(saldosRequest.getMoneda().trim())) {
            builder.add("moneda", saldosRequest.getMoneda());
            requestParamsString = (String)requestParamsString + " moneda [" + saldosRequest.getMoneda() + "]";
        }
        if (saldosRequest.getFechaDesde() != null) {
            builder.add("fechaDesde", saldosRequest.getFechaDesde());
            requestParamsString = (String)requestParamsString + " fechaDesde [" + saldosRequest.getFechaDesde() + "]";
        }
        if (saldosRequest.getFechaHasta() != null) {
            builder.add("fechaHasta", saldosRequest.getFechaHasta());
            requestParamsString = (String)requestParamsString + " fechaHasta [" + saldosRequest.getFechaHasta() + "]";
        }
        if (saldosRequest.getRegistros() != null) {
            builder.add("registros", (Number)saldosRequest.getRegistros());
            requestParamsString = (String)requestParamsString + " registros [" + saldosRequest.getRegistros() + "]";
        }
        if (saldosRequest.getPagina() != null) {
            builder.add("pagina", (Number)saldosRequest.getPagina());
            requestParamsString = (String)requestParamsString + " pagina [" + saldosRequest.getPagina() + "]";
        }
        String path = builder.build();
        log.debug("[getSaldos] Request GET rendiciones con " + (String)requestParamsString);
        SaldosResponse response = (SaldosResponse)this.restConnector.genericGet(null, SaldosResponse.class, path, "clientId", clientCode);
        log.debug("[getSaldos] Response GET rendiciones [" + response + "]");
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

