/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2Refresh;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.interbanking.core.InterbankingApiBaseConnector;
import ar.com.sdd.interbanking.core.InterbankingApiTokenConnectorContext;
import ar.com.sdd.interbanking.io.financiero.AccountsRequest;
import ar.com.sdd.interbanking.io.financiero.AccountsResponse;
import ar.com.sdd.interbanking.io.financiero.BalanceRequest;
import ar.com.sdd.interbanking.io.financiero.BalanceResponse;
import ar.com.sdd.interbanking.io.financiero.MovementsRequest;
import ar.com.sdd.interbanking.io.financiero.MovementsResponse;
import ar.com.sdd.interbanking.model.financiero.ErrorMessage;
import ar.com.sdd.interbanking.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterbankingApiTokenConnector
extends InterbankingApiBaseConnector {
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;
    private static final Logger log = LogManager.getLogger(InterbankingApiTokenConnector.class);
    private InterbankingApiTokenConnectorContext context;
    private RestConnectorEnvironment tokenEnvironment;
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;

    @Override
    public InterbankingApiBaseConnector.ConnectorClass getConnectorClass() {
        return InterbankingApiBaseConnector.ConnectorClass.TOKEN;
    }

    public InterbankingApiTokenConnector(InterbankingApiTokenConnectorContext interbankingApiConnectorContext) {
        this.context = interbankingApiConnectorContext;
        this.environment = new RestConnectorEnvironment(this.context.getBaseUrl(), null, null, null, null);
        this.tokenEnvironment = new RestConnectorEnvironment(this.context.getAuthBaseUrl(), null, null, null, null);
        this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
        log.debug("Creando connector InterbankingApiConnector con [baseUrl='" + this.environment.baseUrl + "',clientId='" + this.context.getClientId() + "']");
    }

    public AccountsResponse getAccounts(String clientCode, AccountsRequest accountsRequest) throws RestConnectorException {
        log.debug("[getAccounts] Request GET con clientCode [" + clientCode + "]");
        Object path = "/accounts";
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        if (!StringUtil.isEmptyNull(accountsRequest.getAccountNumber())) {
            path = (String)path + "/{accountNumber}";
            templateParameters.put("accountNumber", accountsRequest.getAccountNumber());
        }
        QueryBuilder builder = QueryBuilder.Builder().path((String)path);
        StringBuffer requestParamsString = new StringBuffer();
        this.addParameter(builder, requestParamsString, "customer-id", clientCode);
        this.addParameter(builder, requestParamsString, "bank-number", accountsRequest.getBankNumber());
        this.addParameter(builder, requestParamsString, "account-type", accountsRequest.getAccountType());
        this.addParameter(builder, requestParamsString, "currency", accountsRequest.getCurrency());
        this.addParameter(builder, requestParamsString, "limit", accountsRequest.getLimit());
        this.addParameter(builder, requestParamsString, "page", accountsRequest.getPage());
        log.debug("[getAccounts] Request GET con " + requestParamsString);
        AccountsResponse response = (AccountsResponse)this.restConnector.genericGetWithResponseHeader(null, AccountsResponse.class, ErrorMessage.class, builder.build(), templateParameters, 3, 200L).getKey();
        log.debug("[getAccounts] Response GET [" + response + "]");
        return response;
    }

    public BalanceResponse getBalance(String clientCode, BalanceRequest balanceRequest) throws RestConnectorException {
        log.debug("[getBalance] Request GET con clientCode [" + clientCode + "]");
        if (balanceRequest == null) {
            log.warn("[getBalance] No se realiza la consulta de saldos porque balanceRequest es null");
            return null;
        }
        String path = "/accounts/balances";
        HashMap templateParameters = new HashMap();
        QueryBuilder builder = QueryBuilder.Builder().path(path);
        StringBuffer requestParamsString = new StringBuffer();
        this.addParameter(builder, requestParamsString, "customer-id", clientCode);
        this.addParameter(builder, requestParamsString, "bank-number", balanceRequest.getBankNumber());
        this.addParameter(builder, requestParamsString, "account-number", balanceRequest.getAccountNumber());
        this.addParameter(builder, requestParamsString, "account-type", balanceRequest.getAccountType());
        this.addParameter(builder, requestParamsString, "currency", balanceRequest.getCurrency());
        this.addParameter(builder, requestParamsString, "date-since", balanceRequest.getDateSince());
        this.addParameter(builder, requestParamsString, "date-until", balanceRequest.getDateUntil());
        this.addParameter(builder, requestParamsString, "limit", balanceRequest.getLimit());
        this.addParameter(builder, requestParamsString, "page", balanceRequest.getPage());
        log.debug("[getBalance] Request GET con " + requestParamsString);
        int retry = 3;
        RestConnectorException lastException = null;
        while (retry > 0) {
            try {
                BalanceResponse response = (BalanceResponse)this.restConnector.genericGet(null, BalanceResponse.class, ErrorMessage.class, builder.build(), templateParameters);
                log.debug("[getBalance] Response GET [" + response + "]");
                return response;
            }
            catch (RestConnectorException e) {
                log.error("[getBalance] Error al consultar saldo", (Throwable)e);
                lastException = e;
                --retry;
                try {
                    Thread.currentThread().wait(200L);
                }
                catch (InterruptedException e2) {
                    log.error("[getBalance] Error al consultar saldo", (Throwable)e2);
                    lastException = new RestConnectorException((Throwable)e2);
                }
            }
        }
        throw lastException;
    }

    public MovementsResponse getMovements(String clientCode, MovementsRequest movementsRequest) throws RestConnectorException {
        log.debug("[getMovements] Request GET con clientCode [" + clientCode + "]");
        if (movementsRequest == null) {
            log.warn("[getMovements] No se realiza la consulta de saldos porque movementsRequest es null");
            return null;
        }
        String path = "/accounts/{account-number}/movements/{movement-type}";
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        templateParameters.put("account-number", movementsRequest.getAccountNumber());
        templateParameters.put("movement-type", movementsRequest.getMovementType());
        QueryBuilder builder = QueryBuilder.Builder().path(path);
        StringBuffer requestParamsString = new StringBuffer();
        this.addParameter(builder, requestParamsString, "customer-id", clientCode);
        this.addParameter(builder, requestParamsString, "bank-number", movementsRequest.getBankNumber());
        this.addParameter(builder, requestParamsString, "account-number", movementsRequest.getAccountNumber());
        this.addParameter(builder, requestParamsString, "account-type", movementsRequest.getAccountType());
        this.addParameter(builder, requestParamsString, "currency", movementsRequest.getCurrency());
        this.addParameter(builder, requestParamsString, "date-since", movementsRequest.getDateSince());
        this.addParameter(builder, requestParamsString, "date-until", movementsRequest.getDateUntil());
        this.addParameter(builder, requestParamsString, "limit", movementsRequest.getLimit());
        this.addParameter(builder, requestParamsString, "page", movementsRequest.getPage());
        log.debug("[getMovements] Request GET con " + requestParamsString);
        MovementsResponse response = (MovementsResponse)this.restConnector.genericGetWithResponseHeader(null, MovementsResponse.class, ErrorMessage.class, builder.build(), templateParameters, 3, 200L).getKey();
        log.debug("[getMovements] Response GET [" + response + "]");
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        TokenOAuth2Refresh token = this.getToken();
        builder.header("Authorization", (Object)("Bearer " + token.getAccessToken()));
        builder.header("client_id", (Object)this.context.getClientId());
        return builder;
    }

    private TokenOAuth2Refresh getToken() throws RestConnectorException {
        Form form = new Form();
        form.param("grant_type", "client_credentials");
        form.param("client_secret", this.context.getClientSecret());
        form.param("client_id", this.context.getClientId());
        log.trace("[getToken] Por recuperar token con clientId [" + this.context.getClientId() + "], scope [" + this.context.getScope() + "]");
        RestConnector tokenConnector = new RestConnector(this.tokenEnvironment, (RestSecurityManager)new TokenSecurityManager(this.environment, this.context.getService()));
        TokenOAuth2Refresh tokenOAuth2Response = (TokenOAuth2Refresh)tokenConnector.genericPost((Object)form, TokenOAuth2Refresh.class, "/cas/oidc/accessToken?scope=" + this.context.getScope(), "application/json", "application/x-www-form-urlencoded");
        log.debug("[getToken] Token recuperado [" + tokenOAuth2Response + "]");
        return tokenOAuth2Response;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    private void addParameter(QueryBuilder builder, StringBuffer parameterString, String parameterName, String parameterValue) {
        if (!StringUtil.isEmptyNull(parameterValue)) {
            builder.add(parameterName, parameterValue);
            parameterString.append(" ").append(parameterName).append(" [").append(parameterValue).append("]");
        }
    }

    private void addParameter(QueryBuilder builder, StringBuffer parameterString, String parameterName, Date parameterValue) {
        if (parameterValue != null) {
            String sParameterValue = new SimpleDateFormat("yyyy-MM-dd").format(parameterValue);
            builder.add(parameterName, sParameterValue);
            parameterString.append(" ").append(parameterName).append(" [").append(sParameterValue).append("]");
        }
    }

    public static class TokenSecurityManager
    implements RestSecurityManager {
        RestConnectorEnvironment environment;
        String service;

        TokenSecurityManager(RestConnectorEnvironment environment, String service) {
            this.environment = environment;
            this.service = service;
        }

        public Invocation.Builder addHeaders(Invocation.Builder builder) {
            builder.header("service", (Object)this.service);
            return builder;
        }

        public boolean getDisableHTTPSErrors() {
            return false;
        }
    }
}

