package ar.com.sdd.interbanking.io.financiero;

import ar.com.sdd.interbanking.model.financiero.Account;
import ar.com.sdd.interbanking.model.financiero.GeneralData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/*
{  "accounts": [
    {
      "bank_number": "string",
      "account_cbu": "string",
      "account_label": "string",
      "currency": "string",
      "bank_name": "string",
      "account_number": "string",
      "account_type": "string"
    }
  ],
  "general_data": {
    "bank_number": "string",
    "currency": "string",
    "account_number": "string",
    "control_code": "string",
    "page": 0,
    "limit": 0,
    "account_type": "string",
    "total_rows": 0
  }
}
*/
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountsResponse implements Serializable {

    @JsonProperty("accounts")
    private List<Account> accounts;

    @JsonProperty("general_data")
    private GeneralData generalData;

    public List<Account> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public GeneralData getGeneralData() {
        return generalData;
    }

    public void setGeneralData(GeneralData generalData) {
        this.generalData = generalData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AccountsResponse that = (AccountsResponse) o;

        if (!Objects.equals(accounts, that.accounts)) return false;
        return Objects.equals(generalData, that.generalData);
    }

    @Override
    public int hashCode() {
        int result = accounts != null ? accounts.hashCode() : 0;
        result = 31 * result + (generalData != null ? generalData.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AccountsResponse [" +
                "accounts=" + (accounts == null ? accounts : Arrays.toString(accounts.toArray())) +
                ", generalData=" + generalData +
                ']';
    }
}