package ar.com.sdd.interbanking.io.recaudador;

import ar.com.sdd.interbanking.model.recaudador.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RendicionesResponse {

    private Respuesta respuesta;
    private Listado listado;
    private Pagos[] pagos;

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Pagos[] getPagos() {
        return pagos;
    }

    public void setPagos(Pagos[] pagos) {
        this.pagos = pagos;
    }

    @Override
    public String toString() {
        return "RendicionesResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((pagos != null) ? "pagos=" + Arrays.toString(pagos) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RendicionesResponse that = (RendicionesResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return Arrays.equals(pagos, that.pagos);
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (listado != null ? listado.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(pagos);
        return result;
    }
}
