package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

/*
    {
      "bank_number": "string",
      "account_cbu": "string",
      "account_label": "string",
      "currency": "ARS|USD",
      "bank_name": "string",
      "account_number": "string",
      "account_type": "CC"
    }
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account {

    @JsonProperty("bank_number")
    private String bankNumber;

    @JsonProperty("account_cbu")
    private String accountCbu;

    @JsonProperty("account_label")
    private String accountLabel; //Denominacion

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("bank_name")
    private String bankName;

    @JsonProperty("account_number")
    private String accountNumber;

    @JsonProperty("account_type")
    private String accountType;

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public String getAccountCbu() {
        return accountCbu;
    }

    public void setAccountCbu(String accountCbu) {
        this.accountCbu = accountCbu;
    }

    public String getAccountLabel() {
        return accountLabel;
    }

    public void setAccountLabel(String accountLabel) {
        this.accountLabel = accountLabel;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Account account = (Account) o;

        if (!Objects.equals(bankNumber, account.bankNumber)) return false;
        if (!Objects.equals(accountCbu, account.accountCbu)) return false;
        if (!Objects.equals(accountLabel, account.accountLabel)) return false;
        if (!Objects.equals(currency, account.currency)) return false;
        if (!Objects.equals(bankName, account.bankName)) return false;
        if (!Objects.equals(accountNumber, account.accountNumber)) return false;
        return Objects.equals(accountType, account.accountType);
    }

    @Override
    public int hashCode() {
        int result = bankNumber != null ? bankNumber.hashCode() : 0;
        result = 31 * result + (accountCbu != null ? accountCbu.hashCode() : 0);
        result = 31 * result + (accountLabel != null ? accountLabel.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (bankName != null ? bankName.hashCode() : 0);
        result = 31 * result + (accountNumber != null ? accountNumber.hashCode() : 0);
        result = 31 * result + (accountType != null ? accountType.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Account [" +
                "bankNumber=" + bankNumber +
                ", accountCbu=" + accountCbu +
                ", accountLabel=" + accountLabel +
                ", currency=" + currency +
                ", bankName=" + bankName +
                ", accountNumber=" + accountNumber +
                ", accountType=" + accountType +
                ']';
    }
}