package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/*
    {
      "bank_number": "<string>",
      "currency": "<string>",
      "account_number": "<string>",
      "account_type": "CA",
      "account_label": "<string>",
      "account_name": "<string>",
      "row_date": "<dateTime>",
      "message": "<string>",
      "balances": {
        "countable_balance": "<number>",
        "initial_operating_balance": "<number>",
        "current_operating_balance": "<number>",
        "projected_balance_24hs": "<number>",
        "projected_balance_48hs": "<number>"
      },
      "historical_balances": [
        {
          "operation_date": "<dateTime>",
          "day_balance": "<number>",
          "total_debits": "<number>",
          "total_credits": "<number>"
        },
        {
          "operation_date": "<dateTime>",
          "day_balance": "<number>",
          "total_debits": "<number>",
          "total_credits": "<number>"
        }
      ]
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountBalance {

    @JsonProperty("bank_number")
    private String bankNumber;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("account_number")
    private String accountNumber;

    @JsonProperty("account_type")
    private String accountType;

    @JsonProperty("account_label")
    private String accountLabel; //Denominacion

    @JsonProperty("account_name")
    private String accountName;

    @JsonProperty("row-date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT-03:00")
    private Date rowDate;// "2022-03-10T12:15:50.000Z",

    @JsonProperty("message")
    private String message;

    @JsonProperty("balances")
    private Balance balances;

    @JsonProperty("historical_balances")
    private List<HistoricalBalance> historicalBalances;

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getAccountLabel() {
        return accountLabel;
    }

    public void setAccountLabel(String accountLabel) {
        this.accountLabel = accountLabel;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Date getRowDate() {
        return rowDate;
    }

    public void setRowDate(Date rowDate) {
        this.rowDate = rowDate;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Balance getBalances() {
        return balances;
    }

    public void setBalances(Balance balances) {
        this.balances = balances;
    }

    public List<HistoricalBalance> getHistoricalBalances() {
        return historicalBalances;
    }

    public void setHistoricalBalances(List<HistoricalBalance> historicalBalances) {
        this.historicalBalances = historicalBalances;
    }

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AccountBalance that = (AccountBalance) o;

        if (!Objects.equals(bankNumber, that.bankNumber)) return false;
        if (!Objects.equals(currency, that.currency)) return false;
        if (!Objects.equals(accountNumber, that.accountNumber)) return false;
        if (!Objects.equals(accountType, that.accountType)) return false;
        if (!Objects.equals(accountLabel, that.accountLabel)) return false;
        if (!Objects.equals(accountName, that.accountName)) return false;
        if (!Objects.equals(rowDate, that.rowDate)) return false;
        if (!Objects.equals(message, that.message)) return false;
        if (!Objects.equals(balances, that.balances)) return false;
        return Objects.equals(historicalBalances, that.historicalBalances);
    }

    @Override
    public int hashCode() {
        int result = bankNumber != null ? bankNumber.hashCode() : 0;
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (accountNumber != null ? accountNumber.hashCode() : 0);
        result = 31 * result + (accountType != null ? accountType.hashCode() : 0);
        result = 31 * result + (accountLabel != null ? accountLabel.hashCode() : 0);
        result = 31 * result + (accountName != null ? accountName.hashCode() : 0);
        result = 31 * result + (rowDate != null ? rowDate.hashCode() : 0);
        result = 31 * result + (message != null ? message.hashCode() : 0);
        result = 31 * result + (balances != null ? balances.hashCode() : 0);
        result = 31 * result + (historicalBalances != null ? historicalBalances.hashCode() : 0);
        return result;
    }
}