package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;
import java.util.Objects;
/* {
          "operation_date": "<dateTime>",
          "day_balance": "<number>",
          "total_debits": "<number>",
          "total_credits": "<number>"
        },
        {
          "operation_date": "<dateTime>",
          "day_balance": "<number>",
          "total_debits": "<number>",
          "total_credits": "<number>"
        }
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class HistoricalBalance {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    @JsonProperty("operation_date")
    private Date operationDate;

    @JsonProperty("day_balance")
    private Double dayBalance;

    @JsonProperty("total_credits")
    private Double totalCredits;

    @JsonProperty("total_debits")
    private Double totalDebits;

    public Date getOperationDate() {
        return operationDate;
    }

    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }

    public Double getDayBalance() {
        return dayBalance;
    }

    public void setDayBalance(Double dayBalance) {
        this.dayBalance = dayBalance;
    }

    public Double getTotalCredits() {
        return totalCredits;
    }

    public void setTotalCredits(Double totalCredits) {
        this.totalCredits = totalCredits;
    }

    public Double getTotalDebits() {
        return totalDebits;
    }

    public void setTotalDebits(Double totalDebits) {
        this.totalDebits = totalDebits;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HistoricalBalance that = (HistoricalBalance) o;

        if (!Objects.equals(operationDate, that.operationDate)) return false;
        if (!Objects.equals(dayBalance, that.dayBalance)) return false;
        if (!Objects.equals(totalCredits, that.totalCredits)) return false;
        return Objects.equals(totalDebits, that.totalDebits);
    }

    @Override
    public int hashCode() {
        int result = operationDate != null ? operationDate.hashCode() : 0;
        result = 31 * result + (dayBalance != null ? dayBalance.hashCode() : 0);
        result = 31 * result + (totalCredits != null ? totalCredits.hashCode() : 0);
        result = 31 * result + (totalDebits != null ? totalDebits.hashCode() : 0);
        return result;
    }
}