package ar.com.sdd.interbanking.model.recaudador;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Listado {

    /**
     * Cantidad de p&aacute;ginas totales para el filtro seleccionado
     */
    private String totalPagina;

    public String getTotalPagina() {
        return totalPagina;
    }

    public void setTotalPagina(String totalPagina) {
        this.totalPagina = totalPagina;
    }

    @Override
    public String toString() {
        return "Listado ["
                + ((totalPagina != null) ? "totalPagina=" + totalPagina : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Listado listado = (Listado) o;

        return totalPagina != null ? totalPagina.equals(listado.totalPagina) : listado.totalPagina == null;
    }

    @Override
    public int hashCode() {
        return totalPagina != null ? totalPagina.hashCode() : 0;
    }

}
