package ar.com.sdd.jpmorgan.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.jpmorgan.entity.Errors;
import ar.com.sdd.jpmorgan.entity.Response;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.Date;
import java.util.List;

public class JPMorganConnector implements RestSecurityManager {

    private static final Logger log = Logger.getLogger(JPMorganConnector.class);

    private RestConnector restConnector;

    public enum RelativeDateType {
        CURRENT_DAY,
        PRIOR_DAY
    }

    public JPMorganConnector(String baseUrl, String keyStorePath, String keyStorePassword) {
        log.debug("Creando connector con baseUrl [" + baseUrl + "], keyStorePath [" + keyStorePath + "], keyStorePassword [" + keyStorePassword + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, keyStorePath, keyStorePassword, null, null);
        restConnector = new RestConnector(environment, this);
    }

    public Response getTransactions(List<String> accountIds, RelativeDateType relativeDateType, Date startDate, Date endDate) throws RestConnectorException {
        String path = QueryBuilder.Builder().path("/transactions")
                .add("accountIds", accountIds)
                .add("relativeDateType", relativeDateType.name())
                .add("startDate", startDate)
                .add("endDate", endDate)
                .build();

        log.debug("[getTransactions] Request GET transactions con accountIds [" + accountIds + "], relativeDateType [" + relativeDateType + "], startDate [" + startDate + "], endDate [" + endDate + "], path [" + path + "]");
        Response response = restConnector.genericGet(null, Response.class, Errors.class, path);
        log.debug("[getTransactions] Response GET transactions [" + response + "]");
        return response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }
}
