package ar.com.sdd.jpmorgan.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Data {

    @XmlType(name = "PostCodeEnum")
    @XmlEnum(String.class)
    public enum PostCodeEnum {

        @XmlEnumValue("P") P(String.valueOf("P")), @XmlEnumValue("C") C(String.valueOf("C"));


        private String value;

        PostCodeEnum(String v) {
            value = v;
        }

        public static PostCodeEnum fromValue(String value) {
            for (PostCodeEnum b : PostCodeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public String value() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }

    private DataAccount account = null;
    /**
     * Timestamp that the transaction was processed
     **/
    private String asOfDateTime;
    /**
     * Timestamp of when the client requested the payment to execute
     **/
    private String valueDateTime;
    private String recordTimestamp;
    /**
     * When the transaction details were last updated
     **/
    private String lastUpdate;
    /**
     * When the transaction was loaded into queried database
     **/
    private String receivedTimestamp;
    private DataProductGroup productGroup = null;
    /**
     * If the transaction is a Debit or a Credit to the account
     **/
    private String debitCreditCode;
    private DataBaiType baiType = null;
    private String ddaTxnCode;
    private String originalTransactionCode;
    private String fundsTypeCode;
    private DataAccountCurrency currency = null;
    private BigDecimal amount;
    private BigDecimal immediateAvailable;
    private String day1Available;
    private String day2Available;
    private String day2PlusAvailable;
    private String day3PlusAvailable;
    private DataBankReferenceSearchable bankReferenceSearchable = null;
    private DataBankReferenceSearchable customerReferenceSearchable = null;
    private String wireReferenceSearchable;
    private String repairCode;
    private String reversal;
    private String override;
    private String transactionStatus;
    private String shortDescription;
    private String wireType;
    private String checkNumber;
    private String lockboxSequenceCode;
    private String lockboxItems;
    private String lockboxNumber;
    private String lockboxDepositDate;
    private String lockboxDepositTime;
    private Object narrativeText = null;
    private String narrativeTypeCode;
    private String floatSpreadCode;
    private String sepaDetailsXml;
    /**
     * If the transaction is hard-posted to the account, this value will be 'P'. If the transaction is not yet hard-posted, this value will be 'C'.
     **/
    private PostCodeEnum postCode;

    private Object supplementalTextSet = null;

    private String supplementalTextRecordList;

    private String supplementalText;

    private String thirdPartyBank;

    private String achBatchItems;

    private String sepaType;

    /**
     * Get account
     *
     * @return account
     **/
    @JsonProperty("account")
    public DataAccount getAccount() {
        return account;
    }

    public void setAccount(DataAccount account) {
        this.account = account;
    }

    public Data account(DataAccount account) {
        this.account = account;
        return this;
    }

    /**
     * Timestamp that the transaction was processed
     *
     * @return asOfDateTime
     **/
    @JsonProperty("asOfDateTime")
    public String getAsOfDateTime() {
        return asOfDateTime;
    }

    public void setAsOfDateTime(String asOfDateTime) {
        this.asOfDateTime = asOfDateTime;
    }

    public Data asOfDateTime(String asOfDateTime) {
        this.asOfDateTime = asOfDateTime;
        return this;
    }

    /**
     * Timestamp of when the client requested the payment to execute
     *
     * @return valueDateTime
     **/
    @JsonProperty("valueDateTime")
    public String getValueDateTime() {
        return valueDateTime;
    }

    public void setValueDateTime(String valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public Data valueDateTime(String valueDateTime) {
        this.valueDateTime = valueDateTime;
        return this;
    }

    /**
     * Get recordTimestamp
     *
     * @return recordTimestamp
     **/
    @JsonProperty("recordTimestamp")
    public String getRecordTimestamp() {
        return recordTimestamp;
    }

    public void setRecordTimestamp(String recordTimestamp) {
        this.recordTimestamp = recordTimestamp;
    }

    public Data recordTimestamp(String recordTimestamp) {
        this.recordTimestamp = recordTimestamp;
        return this;
    }

    /**
     * When the transaction details were last updated
     *
     * @return lastUpdate
     **/
    @JsonProperty("lastUpdate")
    public String getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Data lastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    /**
     * When the transaction was loaded into queried database
     *
     * @return receivedTimestamp
     **/
    @JsonProperty("receivedTimestamp")
    public String getReceivedTimestamp() {
        return receivedTimestamp;
    }

    public void setReceivedTimestamp(String receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public Data receivedTimestamp(String receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    /**
     * Get productGroup
     *
     * @return productGroup
     **/
    @JsonProperty("productGroup")
    public DataProductGroup getProductGroup() {
        return productGroup;
    }

    public void setProductGroup(DataProductGroup productGroup) {
        this.productGroup = productGroup;
    }

    public Data productGroup(DataProductGroup productGroup) {
        this.productGroup = productGroup;
        return this;
    }

    /**
     * If the transaction is a Debit or a Credit to the account
     *
     * @return debitCreditCode
     **/
    @JsonProperty("debitCreditCode")
    public String getDebitCreditCode() {
        return debitCreditCode;
    }

    public void setDebitCreditCode(String debitCreditCode) {
        this.debitCreditCode = debitCreditCode;
    }

    public Data debitCreditCode(String debitCreditCode) {
        this.debitCreditCode = debitCreditCode;
        return this;
    }

    /**
     * Get baiType
     *
     * @return baiType
     **/
    @JsonProperty("baiType")
    public DataBaiType getBaiType() {
        return baiType;
    }

    public void setBaiType(DataBaiType baiType) {
        this.baiType = baiType;
    }

    public Data baiType(DataBaiType baiType) {
        this.baiType = baiType;
        return this;
    }

    /**
     * Get ddaTxnCode
     *
     * @return ddaTxnCode
     **/
    @JsonProperty("ddaTxnCode")
    public String getDdaTxnCode() {
        return ddaTxnCode;
    }

    public void setDdaTxnCode(String ddaTxnCode) {
        this.ddaTxnCode = ddaTxnCode;
    }

    public Data ddaTxnCode(String ddaTxnCode) {
        this.ddaTxnCode = ddaTxnCode;
        return this;
    }

    /**
     * Get originalTransactionCode
     *
     * @return originalTransactionCode
     **/
    @JsonProperty("originalTransactionCode")
    public String getOriginalTransactionCode() {
        return originalTransactionCode;
    }

    public void setOriginalTransactionCode(String originalTransactionCode) {
        this.originalTransactionCode = originalTransactionCode;
    }

    public Data originalTransactionCode(String originalTransactionCode) {
        this.originalTransactionCode = originalTransactionCode;
        return this;
    }

    /**
     * Get fundsTypeCode
     *
     * @return fundsTypeCode
     **/
    @JsonProperty("fundsTypeCode")
    public String getFundsTypeCode() {
        return fundsTypeCode;
    }

    public void setFundsTypeCode(String fundsTypeCode) {
        this.fundsTypeCode = fundsTypeCode;
    }

    public Data fundsTypeCode(String fundsTypeCode) {
        this.fundsTypeCode = fundsTypeCode;
        return this;
    }

    /**
     * Get currency
     *
     * @return currency
     **/
    @JsonProperty("currency")
    public DataAccountCurrency getCurrency() {
        return currency;
    }

    public void setCurrency(DataAccountCurrency currency) {
        this.currency = currency;
    }

    public Data currency(DataAccountCurrency currency) {
        this.currency = currency;
        return this;
    }

    /**
     * Get amount
     *
     * @return amount
     **/
    @JsonProperty("amount")
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Data amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    /**
     * Get immediateAvailable
     *
     * @return immediateAvailable
     **/
    @JsonProperty("immediateAvailable")
    public BigDecimal getImmediateAvailable() {
        return immediateAvailable;
    }

    public void setImmediateAvailable(BigDecimal immediateAvailable) {
        this.immediateAvailable = immediateAvailable;
    }

    public Data immediateAvailable(BigDecimal immediateAvailable) {
        this.immediateAvailable = immediateAvailable;
        return this;
    }

    /**
     * Get day1Available
     *
     * @return day1Available
     **/
    @JsonProperty("day1Available")
    public String getDay1Available() {
        return day1Available;
    }

    public void setDay1Available(String day1Available) {
        this.day1Available = day1Available;
    }

    public Data day1Available(String day1Available) {
        this.day1Available = day1Available;
        return this;
    }

    /**
     * Get day2Available
     *
     * @return day2Available
     **/
    @JsonProperty("day2Available")
    public String getDay2Available() {
        return day2Available;
    }

    public void setDay2Available(String day2Available) {
        this.day2Available = day2Available;
    }

    public Data day2Available(String day2Available) {
        this.day2Available = day2Available;
        return this;
    }

    /**
     * Get day2PlusAvailable
     *
     * @return day2PlusAvailable
     **/
    @JsonProperty("day2PlusAvailable")
    public String getDay2PlusAvailable() {
        return day2PlusAvailable;
    }

    public void setDay2PlusAvailable(String day2PlusAvailable) {
        this.day2PlusAvailable = day2PlusAvailable;
    }

    public Data day2PlusAvailable(String day2PlusAvailable) {
        this.day2PlusAvailable = day2PlusAvailable;
        return this;
    }

    /**
     * Get day3PlusAvailable
     *
     * @return day3PlusAvailable
     **/
    @JsonProperty("day3PlusAvailable")
    public String getDay3PlusAvailable() {
        return day3PlusAvailable;
    }

    public void setDay3PlusAvailable(String day3PlusAvailable) {
        this.day3PlusAvailable = day3PlusAvailable;
    }

    public Data day3PlusAvailable(String day3PlusAvailable) {
        this.day3PlusAvailable = day3PlusAvailable;
        return this;
    }

    /**
     * Get bankReferenceSearchable
     *
     * @return bankReferenceSearchable
     **/
    @JsonProperty("bankReferenceSearchable")
    public DataBankReferenceSearchable getBankReferenceSearchable() {
        return bankReferenceSearchable;
    }

    public void setBankReferenceSearchable(DataBankReferenceSearchable bankReferenceSearchable) {
        this.bankReferenceSearchable = bankReferenceSearchable;
    }

    public Data bankReferenceSearchable(DataBankReferenceSearchable bankReferenceSearchable) {
        this.bankReferenceSearchable = bankReferenceSearchable;
        return this;
    }

    /**
     * Get customerReferenceSearchable
     *
     * @return customerReferenceSearchable
     **/
    @JsonProperty("customerReferenceSearchable")
    public DataBankReferenceSearchable getCustomerReferenceSearchable() {
        return customerReferenceSearchable;
    }

    public void setCustomerReferenceSearchable(DataBankReferenceSearchable customerReferenceSearchable) {
        this.customerReferenceSearchable = customerReferenceSearchable;
    }

    public Data customerReferenceSearchable(DataBankReferenceSearchable customerReferenceSearchable) {
        this.customerReferenceSearchable = customerReferenceSearchable;
        return this;
    }

    /**
     * Get wireReferenceSearchable
     *
     * @return wireReferenceSearchable
     **/
    @JsonProperty("wireReferenceSearchable")
    public String getWireReferenceSearchable() {
        return wireReferenceSearchable;
    }

    public void setWireReferenceSearchable(String wireReferenceSearchable) {
        this.wireReferenceSearchable = wireReferenceSearchable;
    }

    public Data wireReferenceSearchable(String wireReferenceSearchable) {
        this.wireReferenceSearchable = wireReferenceSearchable;
        return this;
    }

    /**
     * Get repairCode
     *
     * @return repairCode
     **/
    @JsonProperty("repairCode")
    public String getRepairCode() {
        return repairCode;
    }

    public void setRepairCode(String repairCode) {
        this.repairCode = repairCode;
    }

    public Data repairCode(String repairCode) {
        this.repairCode = repairCode;
        return this;
    }

    /**
     * Get reversal
     *
     * @return reversal
     **/
    @JsonProperty("reversal")
    public String getReversal() {
        return reversal;
    }

    public void setReversal(String reversal) {
        this.reversal = reversal;
    }

    public Data reversal(String reversal) {
        this.reversal = reversal;
        return this;
    }

    /**
     * Get override
     *
     * @return override
     **/
    @JsonProperty("override")
    public String getOverride() {
        return override;
    }

    public void setOverride(String override) {
        this.override = override;
    }

    public Data override(String override) {
        this.override = override;
        return this;
    }

    /**
     * Get transactionStatus
     *
     * @return transactionStatus
     **/
    @JsonProperty("transactionStatus")
    public String getTransactionStatus() {
        return transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Data transactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    /**
     * Get shortDescription
     *
     * @return shortDescription
     **/
    @JsonProperty("shortDescription")
    public String getShortDescription() {
        return shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public Data shortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    /**
     * Get wireType
     *
     * @return wireType
     **/
    @JsonProperty("wireType")
    public String getWireType() {
        return wireType;
    }

    public void setWireType(String wireType) {
        this.wireType = wireType;
    }

    public Data wireType(String wireType) {
        this.wireType = wireType;
        return this;
    }

    /**
     * Get checkNumber
     *
     * @return checkNumber
     **/
    @JsonProperty("checkNumber")
    public String getCheckNumber() {
        return checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public Data checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    /**
     * Get lockboxSequenceCode
     *
     * @return lockboxSequenceCode
     **/
    @JsonProperty("lockboxSequenceCode")
    public String getLockboxSequenceCode() {
        return lockboxSequenceCode;
    }

    public void setLockboxSequenceCode(String lockboxSequenceCode) {
        this.lockboxSequenceCode = lockboxSequenceCode;
    }

    public Data lockboxSequenceCode(String lockboxSequenceCode) {
        this.lockboxSequenceCode = lockboxSequenceCode;
        return this;
    }

    /**
     * Get lockboxItems
     *
     * @return lockboxItems
     **/
    @JsonProperty("lockboxItems")
    public String getLockboxItems() {
        return lockboxItems;
    }

    public void setLockboxItems(String lockboxItems) {
        this.lockboxItems = lockboxItems;
    }

    public Data lockboxItems(String lockboxItems) {
        this.lockboxItems = lockboxItems;
        return this;
    }

    /**
     * Get lockboxNumber
     *
     * @return lockboxNumber
     **/
    @JsonProperty("lockboxNumber")
    public String getLockboxNumber() {
        return lockboxNumber;
    }

    public void setLockboxNumber(String lockboxNumber) {
        this.lockboxNumber = lockboxNumber;
    }

    public Data lockboxNumber(String lockboxNumber) {
        this.lockboxNumber = lockboxNumber;
        return this;
    }

    /**
     * Get lockboxDepositDate
     *
     * @return lockboxDepositDate
     **/
    @JsonProperty("lockboxDepositDate")
    public String getLockboxDepositDate() {
        return lockboxDepositDate;
    }

    public void setLockboxDepositDate(String lockboxDepositDate) {
        this.lockboxDepositDate = lockboxDepositDate;
    }

    public Data lockboxDepositDate(String lockboxDepositDate) {
        this.lockboxDepositDate = lockboxDepositDate;
        return this;
    }

    /**
     * Get lockboxDepositTime
     *
     * @return lockboxDepositTime
     **/
    @JsonProperty("lockboxDepositTime")
    public String getLockboxDepositTime() {
        return lockboxDepositTime;
    }

    public void setLockboxDepositTime(String lockboxDepositTime) {
        this.lockboxDepositTime = lockboxDepositTime;
    }

    public Data lockboxDepositTime(String lockboxDepositTime) {
        this.lockboxDepositTime = lockboxDepositTime;
        return this;
    }

    /**
     * Get narrativeText
     *
     * @return narrativeText
     **/
    @JsonProperty("narrativeText")
    public Object getNarrativeText() {
        return narrativeText;
    }

    public void setNarrativeText(Object narrativeText) {
        this.narrativeText = narrativeText;
    }

    public Data narrativeText(Object narrativeText) {
        this.narrativeText = narrativeText;
        return this;
    }

    /**
     * Get narrativeTypeCode
     *
     * @return narrativeTypeCode
     **/
    @JsonProperty("narrativeTypeCode")
    public String getNarrativeTypeCode() {
        return narrativeTypeCode;
    }

    public void setNarrativeTypeCode(String narrativeTypeCode) {
        this.narrativeTypeCode = narrativeTypeCode;
    }

    public Data narrativeTypeCode(String narrativeTypeCode) {
        this.narrativeTypeCode = narrativeTypeCode;
        return this;
    }

    /**
     * Get floatSpreadCode
     *
     * @return floatSpreadCode
     **/
    @JsonProperty("floatSpreadCode")
    public String getFloatSpreadCode() {
        return floatSpreadCode;
    }

    public void setFloatSpreadCode(String floatSpreadCode) {
        this.floatSpreadCode = floatSpreadCode;
    }

    public Data floatSpreadCode(String floatSpreadCode) {
        this.floatSpreadCode = floatSpreadCode;
        return this;
    }

    /**
     * Get sepaDetailsXml
     *
     * @return sepaDetailsXml
     **/
    @JsonProperty("sepaDetailsXml")
    public String getSepaDetailsXml() {
        return sepaDetailsXml;
    }

    public void setSepaDetailsXml(String sepaDetailsXml) {
        this.sepaDetailsXml = sepaDetailsXml;
    }

    public Data sepaDetailsXml(String sepaDetailsXml) {
        this.sepaDetailsXml = sepaDetailsXml;
        return this;
    }

    /**
     * If the transaction is hard-posted to the account, this value will be &#39;P&#39;. If the transaction is not yet hard-posted, this value will be &#39;C&#39;.
     *
     * @return postCode
     **/
    @JsonProperty("postCode")
    public String getPostCode() {
        if (postCode == null) {
            return null;
        }
        return postCode.value();
    }

    public void setPostCode(PostCodeEnum postCode) {
        this.postCode = postCode;
    }

    public Data postCode(PostCodeEnum postCode) {
        this.postCode = postCode;
        return this;
    }

    /**
     * Get supplementalTextSet
     *
     * @return supplementalTextSet
     **/
    @JsonProperty("supplementalTextSet")
    public Object getSupplementalTextSet() {
        return supplementalTextSet;
    }

    public void setSupplementalTextSet(Object supplementalTextSet) {
        this.supplementalTextSet = supplementalTextSet;
    }

    public Data supplementalTextSet(Object supplementalTextSet) {
        this.supplementalTextSet = supplementalTextSet;
        return this;
    }

    /**
     * Get supplementalTextRecordList
     *
     * @return supplementalTextRecordList
     **/
    @JsonProperty("supplementalTextRecordList")
    public String getSupplementalTextRecordList() {
        return supplementalTextRecordList;
    }

    public void setSupplementalTextRecordList(String supplementalTextRecordList) {
        this.supplementalTextRecordList = supplementalTextRecordList;
    }

    public Data supplementalTextRecordList(String supplementalTextRecordList) {
        this.supplementalTextRecordList = supplementalTextRecordList;
        return this;
    }

    /**
     * Get supplementalText
     *
     * @return supplementalText
     **/
    @JsonProperty("supplementalText")
    public String getSupplementalText() {
        return supplementalText;
    }

    public void setSupplementalText(String supplementalText) {
        this.supplementalText = supplementalText;
    }

    public Data supplementalText(String supplementalText) {
        this.supplementalText = supplementalText;
        return this;
    }

    /**
     * Get thirdPartyBank
     *
     * @return thirdPartyBank
     **/
    @JsonProperty("thirdPartyBank")
    public String getThirdPartyBank() {
        return thirdPartyBank;
    }

    public void setThirdPartyBank(String thirdPartyBank) {
        this.thirdPartyBank = thirdPartyBank;
    }

    public Data thirdPartyBank(String thirdPartyBank) {
        this.thirdPartyBank = thirdPartyBank;
        return this;
    }

    /**
     * Get achBatchItems
     *
     * @return achBatchItems
     **/
    @JsonProperty("achBatchItems")
    public String getAchBatchItems() {
        return achBatchItems;
    }

    public void setAchBatchItems(String achBatchItems) {
        this.achBatchItems = achBatchItems;
    }

    public Data achBatchItems(String achBatchItems) {
        this.achBatchItems = achBatchItems;
        return this;
    }

    /**
     * Get sepaType
     *
     * @return sepaType
     **/
    @JsonProperty("sepaType")
    public String getSepaType() {
        return sepaType;
    }

    public void setSepaType(String sepaType) {
        this.sepaType = sepaType;
    }

    public Data sepaType(String sepaType) {
        this.sepaType = sepaType;
        return this;
    }

    @Override
    public String toString() {
        return "Data ["
                + ((account != null) ? "account=" + account + ", " : "")
                + ((asOfDateTime != null) ? "asOfDateTime=" + asOfDateTime + ", " : "")
                + ((valueDateTime != null) ? "valueDateTime=" + valueDateTime + ", " : "")
                + ((recordTimestamp != null) ? "recordTimestamp=" + recordTimestamp + ", " : "")
                + ((lastUpdate != null) ? "lastUpdate=" + lastUpdate + ", " : "")
                + ((receivedTimestamp != null) ? "receivedTimestamp=" + receivedTimestamp + ", " : "")
                + ((productGroup != null) ? "productGroup=" + productGroup + ", " : "")
                + ((debitCreditCode != null) ? "debitCreditCode=" + debitCreditCode + ", " : "")
                + ((baiType != null) ? "baiType=" + baiType + ", " : "")
                + ((ddaTxnCode != null) ? "ddaTxnCode=" + ddaTxnCode + ", " : "")
                + ((originalTransactionCode != null) ? "originalTransactionCode=" + originalTransactionCode + ", " : "")
                + ((fundsTypeCode != null) ? "fundsTypeCode=" + fundsTypeCode + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((immediateAvailable != null) ? "immediateAvailable=" + immediateAvailable + ", " : "")
                + ((day1Available != null) ? "day1Available=" + day1Available + ", " : "")
                + ((day2Available != null) ? "day2Available=" + day2Available + ", " : "")
                + ((day2PlusAvailable != null) ? "day2PlusAvailable=" + day2PlusAvailable + ", " : "")
                + ((day3PlusAvailable != null) ? "day3PlusAvailable=" + day3PlusAvailable + ", " : "")
                + ((bankReferenceSearchable != null) ? "bankReferenceSearchable=" + bankReferenceSearchable + ", " : "")
                + ((customerReferenceSearchable != null) ? "customerReferenceSearchable=" + customerReferenceSearchable + ", " : "")
                + ((wireReferenceSearchable != null) ? "wireReferenceSearchable=" + wireReferenceSearchable + ", " : "")
                + ((repairCode != null) ? "repairCode=" + repairCode + ", " : "")
                + ((reversal != null) ? "reversal=" + reversal + ", " : "")
                + ((override != null) ? "override=" + override + ", " : "")
                + ((transactionStatus != null) ? "transactionStatus=" + transactionStatus + ", " : "")
                + ((shortDescription != null) ? "shortDescription=" + shortDescription + ", " : "")
                + ((wireType != null) ? "wireType=" + wireType + ", " : "")
                + ((checkNumber != null) ? "checkNumber=" + checkNumber + ", " : "")
                + ((lockboxSequenceCode != null) ? "lockboxSequenceCode=" + lockboxSequenceCode + ", " : "")
                + ((lockboxItems != null) ? "lockboxItems=" + lockboxItems + ", " : "")
                + ((lockboxNumber != null) ? "lockboxNumber=" + lockboxNumber + ", " : "")
                + ((lockboxDepositDate != null) ? "lockboxDepositDate=" + lockboxDepositDate + ", " : "")
                + ((lockboxDepositTime != null) ? "lockboxDepositTime=" + lockboxDepositTime + ", " : "")
                + ((narrativeText != null) ? "narrativeText=" + narrativeText + ", " : "")
                + ((narrativeTypeCode != null) ? "narrativeTypeCode=" + narrativeTypeCode + ", " : "")
                + ((floatSpreadCode != null) ? "floatSpreadCode=" + floatSpreadCode + ", " : "")
                + ((sepaDetailsXml != null) ? "sepaDetailsXml=" + sepaDetailsXml + ", " : "")
                + ((postCode != null) ? "postCode=" + postCode + ", " : "")
                + ((supplementalTextSet != null) ? "supplementalTextSet=" + supplementalTextSet + ", " : "")
                + ((supplementalTextRecordList != null) ? "supplementalTextRecordList=" + supplementalTextRecordList + ", " : "")
                + ((supplementalText != null) ? "supplementalText=" + supplementalText + ", " : "")
                + ((thirdPartyBank != null) ? "thirdPartyBank=" + thirdPartyBank + ", " : "")
                + ((achBatchItems != null) ? "achBatchItems=" + achBatchItems + ", " : "")
                + ((sepaType != null) ? "sepaType=" + sepaType : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Data data = (Data) o;

        if (account != null ? !account.equals(data.account) : data.account != null) return false;
        if (asOfDateTime != null ? !asOfDateTime.equals(data.asOfDateTime) : data.asOfDateTime != null) return false;
        if (valueDateTime != null ? !valueDateTime.equals(data.valueDateTime) : data.valueDateTime != null) return false;
        if (recordTimestamp != null ? !recordTimestamp.equals(data.recordTimestamp) : data.recordTimestamp != null) return false;
        if (lastUpdate != null ? !lastUpdate.equals(data.lastUpdate) : data.lastUpdate != null) return false;
        if (receivedTimestamp != null ? !receivedTimestamp.equals(data.receivedTimestamp) : data.receivedTimestamp != null) return false;
        if (productGroup != null ? !productGroup.equals(data.productGroup) : data.productGroup != null) return false;
        if (debitCreditCode != null ? !debitCreditCode.equals(data.debitCreditCode) : data.debitCreditCode != null) return false;
        if (baiType != null ? !baiType.equals(data.baiType) : data.baiType != null) return false;
        if (ddaTxnCode != null ? !ddaTxnCode.equals(data.ddaTxnCode) : data.ddaTxnCode != null) return false;
        if (originalTransactionCode != null ? !originalTransactionCode.equals(data.originalTransactionCode) : data.originalTransactionCode != null) return false;
        if (fundsTypeCode != null ? !fundsTypeCode.equals(data.fundsTypeCode) : data.fundsTypeCode != null) return false;
        if (currency != null ? !currency.equals(data.currency) : data.currency != null) return false;
        if (amount != null ? !amount.equals(data.amount) : data.amount != null) return false;
        if (immediateAvailable != null ? !immediateAvailable.equals(data.immediateAvailable) : data.immediateAvailable != null) return false;
        if (day1Available != null ? !day1Available.equals(data.day1Available) : data.day1Available != null) return false;
        if (day2Available != null ? !day2Available.equals(data.day2Available) : data.day2Available != null) return false;
        if (day2PlusAvailable != null ? !day2PlusAvailable.equals(data.day2PlusAvailable) : data.day2PlusAvailable != null) return false;
        if (day3PlusAvailable != null ? !day3PlusAvailable.equals(data.day3PlusAvailable) : data.day3PlusAvailable != null) return false;
        if (bankReferenceSearchable != null ? !bankReferenceSearchable.equals(data.bankReferenceSearchable) : data.bankReferenceSearchable != null) return false;
        if (customerReferenceSearchable != null ? !customerReferenceSearchable.equals(data.customerReferenceSearchable) : data.customerReferenceSearchable != null) return false;
        if (wireReferenceSearchable != null ? !wireReferenceSearchable.equals(data.wireReferenceSearchable) : data.wireReferenceSearchable != null) return false;
        if (repairCode != null ? !repairCode.equals(data.repairCode) : data.repairCode != null) return false;
        if (reversal != null ? !reversal.equals(data.reversal) : data.reversal != null) return false;
        if (override != null ? !override.equals(data.override) : data.override != null) return false;
        if (transactionStatus != null ? !transactionStatus.equals(data.transactionStatus) : data.transactionStatus != null) return false;
        if (shortDescription != null ? !shortDescription.equals(data.shortDescription) : data.shortDescription != null) return false;
        if (wireType != null ? !wireType.equals(data.wireType) : data.wireType != null) return false;
        if (checkNumber != null ? !checkNumber.equals(data.checkNumber) : data.checkNumber != null) return false;
        if (lockboxSequenceCode != null ? !lockboxSequenceCode.equals(data.lockboxSequenceCode) : data.lockboxSequenceCode != null) return false;
        if (lockboxItems != null ? !lockboxItems.equals(data.lockboxItems) : data.lockboxItems != null) return false;
        if (lockboxNumber != null ? !lockboxNumber.equals(data.lockboxNumber) : data.lockboxNumber != null) return false;
        if (lockboxDepositDate != null ? !lockboxDepositDate.equals(data.lockboxDepositDate) : data.lockboxDepositDate != null) return false;
        if (lockboxDepositTime != null ? !lockboxDepositTime.equals(data.lockboxDepositTime) : data.lockboxDepositTime != null) return false;
        if (narrativeText != null ? !narrativeText.equals(data.narrativeText) : data.narrativeText != null) return false;
        if (narrativeTypeCode != null ? !narrativeTypeCode.equals(data.narrativeTypeCode) : data.narrativeTypeCode != null) return false;
        if (floatSpreadCode != null ? !floatSpreadCode.equals(data.floatSpreadCode) : data.floatSpreadCode != null) return false;
        if (sepaDetailsXml != null ? !sepaDetailsXml.equals(data.sepaDetailsXml) : data.sepaDetailsXml != null) return false;
        if (postCode != data.postCode) return false;
        if (supplementalTextSet != null ? !supplementalTextSet.equals(data.supplementalTextSet) : data.supplementalTextSet != null) return false;
        if (supplementalTextRecordList != null ? !supplementalTextRecordList.equals(data.supplementalTextRecordList) : data.supplementalTextRecordList != null) return false;
        if (supplementalText != null ? !supplementalText.equals(data.supplementalText) : data.supplementalText != null) return false;
        if (thirdPartyBank != null ? !thirdPartyBank.equals(data.thirdPartyBank) : data.thirdPartyBank != null) return false;
        if (achBatchItems != null ? !achBatchItems.equals(data.achBatchItems) : data.achBatchItems != null) return false;
        return sepaType != null ? sepaType.equals(data.sepaType) : data.sepaType == null;
    }

    @Override
    public int hashCode() {
        int result = account != null ? account.hashCode() : 0;
        result = 31 * result + (asOfDateTime != null ? asOfDateTime.hashCode() : 0);
        result = 31 * result + (valueDateTime != null ? valueDateTime.hashCode() : 0);
        result = 31 * result + (recordTimestamp != null ? recordTimestamp.hashCode() : 0);
        result = 31 * result + (lastUpdate != null ? lastUpdate.hashCode() : 0);
        result = 31 * result + (receivedTimestamp != null ? receivedTimestamp.hashCode() : 0);
        result = 31 * result + (productGroup != null ? productGroup.hashCode() : 0);
        result = 31 * result + (debitCreditCode != null ? debitCreditCode.hashCode() : 0);
        result = 31 * result + (baiType != null ? baiType.hashCode() : 0);
        result = 31 * result + (ddaTxnCode != null ? ddaTxnCode.hashCode() : 0);
        result = 31 * result + (originalTransactionCode != null ? originalTransactionCode.hashCode() : 0);
        result = 31 * result + (fundsTypeCode != null ? fundsTypeCode.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (immediateAvailable != null ? immediateAvailable.hashCode() : 0);
        result = 31 * result + (day1Available != null ? day1Available.hashCode() : 0);
        result = 31 * result + (day2Available != null ? day2Available.hashCode() : 0);
        result = 31 * result + (day2PlusAvailable != null ? day2PlusAvailable.hashCode() : 0);
        result = 31 * result + (day3PlusAvailable != null ? day3PlusAvailable.hashCode() : 0);
        result = 31 * result + (bankReferenceSearchable != null ? bankReferenceSearchable.hashCode() : 0);
        result = 31 * result + (customerReferenceSearchable != null ? customerReferenceSearchable.hashCode() : 0);
        result = 31 * result + (wireReferenceSearchable != null ? wireReferenceSearchable.hashCode() : 0);
        result = 31 * result + (repairCode != null ? repairCode.hashCode() : 0);
        result = 31 * result + (reversal != null ? reversal.hashCode() : 0);
        result = 31 * result + (override != null ? override.hashCode() : 0);
        result = 31 * result + (transactionStatus != null ? transactionStatus.hashCode() : 0);
        result = 31 * result + (shortDescription != null ? shortDescription.hashCode() : 0);
        result = 31 * result + (wireType != null ? wireType.hashCode() : 0);
        result = 31 * result + (checkNumber != null ? checkNumber.hashCode() : 0);
        result = 31 * result + (lockboxSequenceCode != null ? lockboxSequenceCode.hashCode() : 0);
        result = 31 * result + (lockboxItems != null ? lockboxItems.hashCode() : 0);
        result = 31 * result + (lockboxNumber != null ? lockboxNumber.hashCode() : 0);
        result = 31 * result + (lockboxDepositDate != null ? lockboxDepositDate.hashCode() : 0);
        result = 31 * result + (lockboxDepositTime != null ? lockboxDepositTime.hashCode() : 0);
        result = 31 * result + (narrativeText != null ? narrativeText.hashCode() : 0);
        result = 31 * result + (narrativeTypeCode != null ? narrativeTypeCode.hashCode() : 0);
        result = 31 * result + (floatSpreadCode != null ? floatSpreadCode.hashCode() : 0);
        result = 31 * result + (sepaDetailsXml != null ? sepaDetailsXml.hashCode() : 0);
        result = 31 * result + (postCode != null ? postCode.hashCode() : 0);
        result = 31 * result + (supplementalTextSet != null ? supplementalTextSet.hashCode() : 0);
        result = 31 * result + (supplementalTextRecordList != null ? supplementalTextRecordList.hashCode() : 0);
        result = 31 * result + (supplementalText != null ? supplementalText.hashCode() : 0);
        result = 31 * result + (thirdPartyBank != null ? thirdPartyBank.hashCode() : 0);
        result = 31 * result + (achBatchItems != null ? achBatchItems.hashCode() : 0);
        result = 31 * result + (sepaType != null ? sepaType.hashCode() : 0);
        return result;
    }
}

