package ar.com.sdd.jpmorgan.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DataProductGroup {

    private String groupCode;

    private String groupDescription;

    private Boolean wire;

    /**
     * Get groupCode
     *
     * @return groupCode
     **/
    @JsonProperty("groupCode")
    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public DataProductGroup groupCode(String groupCode) {
        this.groupCode = groupCode;
        return this;
    }

    /**
     * Get groupDescription
     *
     * @return groupDescription
     **/
    @JsonProperty("groupDescription")
    public String getGroupDescription() {
        return groupDescription;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public DataProductGroup groupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
        return this;
    }

    /**
     * Get wire
     *
     * @return wire
     **/
    @JsonProperty("wire")
    public Boolean getWire() {
        return wire;
    }

    public void setWire(Boolean wire) {
        this.wire = wire;
    }

    public DataProductGroup wire(Boolean wire) {
        this.wire = wire;
        return this;
    }

    @Override
    public String toString() {
        return "DataProductGroup ["
                + ((groupCode != null) ? "groupCode=" + groupCode + ", " : "")
                + ((groupDescription != null) ? "groupDescription=" + groupDescription + ", " : "")
                + ((wire != null) ? "wire=" + wire : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataProductGroup that = (DataProductGroup) o;

        if (groupCode != null ? !groupCode.equals(that.groupCode) : that.groupCode != null) return false;
        if (groupDescription != null ? !groupDescription.equals(that.groupDescription) : that.groupDescription != null) return false;
        return wire != null ? wire.equals(that.wire) : that.wire == null;
    }

    @Override
    public int hashCode() {
        int result = groupCode != null ? groupCode.hashCode() : 0;
        result = 31 * result + (groupDescription != null ? groupDescription.hashCode() : 0);
        result = 31 * result + (wire != null ? wire.hashCode() : 0);
        return result;
    }
}

