package ar.com.sdd.jpmorgan.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;

/*
 * Antes se llamaba InlineResponse400
 */

@JsonIgnoreProperties(ignoreUnknown = true)
public class Errors {

    private List<Error> errors = null;

    /**
     * Get errors
     *
     * @return errors
     **/
    @JsonProperty("errors")
    public List<Error> getErrors() {
        return errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public Errors errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public Errors addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }


    @Override
    public String toString() {
        return "Errors ["
                + ((errors != null) ? "errors=" + Arrays.toString(errors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Errors that = (Errors) o;

        return errors != null ? errors.equals(that.errors) : that.errors == null;
    }

    @Override
    public int hashCode() {
        return errors != null ? errors.hashCode() : 0;
    }
}

