package ar.com.sdd.jpmorgan.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.jpmorgan.entity.Errors;
import ar.com.sdd.jpmorgan.entity.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.Date;

public class JPMorganConnector implements RestSecurityManager {

    private static final Logger log = Logger.getLogger(JPMorganConnector.class);

    private RestConnector restConnector;

    public enum RelativeDateType {
        CURRENT_DAY,
        PRIOR_DAY
    }

    public JPMorganConnector(JPMorganContext context) {
        this(context.getJpMorganBaseUrl(), context.getJpMorganKeyStorePath(), context.getJpMorganKeyStorePassword());
    }

    public JPMorganConnector(String baseUrl, String keyStorePath, String keyStorePassword) {
        log.debug("Creando connector con baseUrl [" + baseUrl + "], keyStorePath [" + keyStorePath + "], keyStorePassword [" + keyStorePassword + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, keyStorePath, keyStorePassword, null, null);
        restConnector = new RestConnector(environment, this);
    }

    public Response getTransactions(String accountIds, RelativeDateType relativeDateType, Date startDate, Date endDate) throws RestConnectorException {
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/transactions")
                .add("relativeDateType", relativeDateType.name())
                .add("startDate", startDate)
                .add("endDate", endDate);

        if (StringUtils.isNotEmpty(accountIds)) {
            queryBuilder.add("accountIds", accountIds);
        }

        String path = queryBuilder.build();

        log.debug("[getTransactions] Request GET transactions con accountIds [" + accountIds + "], relativeDateType [" + relativeDateType + "], startDate [" + startDate + "], endDate [" + endDate + "], path [" + path + "]");
        Response response = restConnector.genericGet(null, Response.class, Errors.class, path);
        log.debug("[getTransactions] Response GET transactions [" + response + "]");
        return response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }
}
