package ar.com.sdd.jpmorgan.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DataAccountCurrency {

    private String code;

    private String description;

    private BigDecimal decimalLocation;

    private String currencySequence;


    /**
     * Get code
     *
     * @return code
     **/
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public DataAccountCurrency code(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get description
     *
     * @return description
     **/
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataAccountCurrency description(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get decimalLocation
     *
     * @return decimalLocation
     **/
    @JsonProperty("decimalLocation")
    public BigDecimal getDecimalLocation() {
        return decimalLocation;
    }

    public void setDecimalLocation(BigDecimal decimalLocation) {
        this.decimalLocation = decimalLocation;
    }

    public DataAccountCurrency decimalLocation(BigDecimal decimalLocation) {
        this.decimalLocation = decimalLocation;
        return this;
    }

    /**
     * Get currencySequence
     *
     * @return currencySequence
     **/
    @JsonProperty("currencySequence")
    public String getCurrencySequence() {
        return currencySequence;
    }

    public void setCurrencySequence(String currencySequence) {
        this.currencySequence = currencySequence;
    }

    public DataAccountCurrency currencySequence(String currencySequence) {
        this.currencySequence = currencySequence;
        return this;
    }

    @Override
    public String toString() {
        return "DataAccountCurrency ["
                + ((code != null) ? "code=" + code + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((decimalLocation != null) ? "decimalLocation=" + decimalLocation + ", " : "")
                + ((currencySequence != null) ? "currencySequence=" + currencySequence : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataAccountCurrency that = (DataAccountCurrency) o;

        if (code != null ? !code.equals(that.code) : that.code != null) return false;
        if (description != null ? !description.equals(that.description) : that.description != null) return false;
        if (decimalLocation != null ? !decimalLocation.equals(that.decimalLocation) : that.decimalLocation != null) return false;
        return currencySequence != null ? currencySequence.equals(that.currencySequence) : that.currencySequence == null;
    }

    @Override
    public int hashCode() {
        int result = code != null ? code.hashCode() : 0;
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (decimalLocation != null ? decimalLocation.hashCode() : 0);
        result = 31 * result + (currencySequence != null ? currencySequence.hashCode() : 0);
        return result;
    }
}

