package ar.com.sdd.jpmorgan.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DataBankReferenceSearchable {

    private String standardValue;

    private String searchValue;


    /**
     * Get standardValue
     *
     * @return standardValue
     **/
    @JsonProperty("standardValue")
    public String getStandardValue() {
        return standardValue;
    }

    public void setStandardValue(String standardValue) {
        this.standardValue = standardValue;
    }

    public DataBankReferenceSearchable standardValue(String standardValue) {
        this.standardValue = standardValue;
        return this;
    }

    /**
     * Get searchValue
     *
     * @return searchValue
     **/
    @JsonProperty("searchValue")
    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public DataBankReferenceSearchable searchValue(String searchValue) {
        this.searchValue = searchValue;
        return this;
    }

    @Override
    public String toString() {
        return "DataBankReferenceSearchable ["
                + ((standardValue != null) ? "standardValue=" + standardValue + ", " : "")
                + ((searchValue != null) ? "searchValue=" + searchValue : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataBankReferenceSearchable that = (DataBankReferenceSearchable) o;

        if (standardValue != null ? !standardValue.equals(that.standardValue) : that.standardValue != null) return false;
        return searchValue != null ? searchValue.equals(that.searchValue) : that.searchValue == null;
    }

    @Override
    public int hashCode() {
        int result = standardValue != null ? standardValue.hashCode() : 0;
        result = 31 * result + (searchValue != null ? searchValue.hashCode() : 0);
        return result;
    }
}

