package ar.com.sdd.jpmorgan.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Error {

    private String errorCode;

    private String errorMsg;

    /**
     * Get errorCode
     *
     * @return errorCode
     **/
    @JsonProperty("errorCode")
    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Error errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    /**
     * Get errorMsg
     *
     * @return errorMsg
     **/
    @JsonProperty("errorMsg")
    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Error errorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    @Override
    public String toString() {
        return "Error ["
                + ((errorCode != null) ? "errorCode=" + errorCode + ", " : "")
                + ((errorMsg != null) ? "errorMsg=" + errorMsg : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Error error = (Error) o;

        if (errorCode != null ? !errorCode.equals(error.errorCode) : error.errorCode != null) return false;
        return errorMsg != null ? errorMsg.equals(error.errorMsg) : error.errorMsg == null;
    }

    @Override
    public int hashCode() {
        int result = errorCode != null ? errorCode.hashCode() : 0;
        result = 31 * result + (errorMsg != null ? errorMsg.hashCode() : 0);
        return result;
    }
}

