package ar.com.sdd.jpmorgan.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Response {

    private List<Data> data = null;

    /**
     * Get data
     *
     * @return data
     **/
    @JsonProperty("data")
    public List<Data> getData() {
        return data;
    }

    public void setData(List<Data> data) {
        this.data = data;
    }

    public Response data(List<Data> data) {
        this.data = data;
        return this;
    }

    public Response addDataItem(Data dataItem) {
        this.data.add(dataItem);
        return this;
    }

    @Override
    public String toString() {
        return "Response ["
                + ((data != null) ? "data=" + Arrays.toString(data.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Response response = (Response) o;

        return data != null ? data.equals(response.data) : response.data == null;
    }

    @Override
    public int hashCode() {
        return data != null ? data.hashCode() : 0;
    }
}

