package ar.com.sdd.jpmorgan.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DataAccount {

    private String accountId;

    private String accountName;

    private String bankId;

    private String branchId;

    private String bankName;

    private DataAccountCurrency currency = null;

    /**
     * Get accountId
     *
     * @return accountId
     **/
    @JsonProperty("accountId")
    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public DataAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    /**
     * Get accountName
     *
     * @return accountName
     **/
    @JsonProperty("accountName")
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public DataAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get bankId
     *
     * @return bankId
     **/
    @JsonProperty("bankId")
    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public DataAccount bankId(String bankId) {
        this.bankId = bankId;
        return this;
    }

    /**
     * Get branchId
     *
     * @return branchId
     **/
    @JsonProperty("branchId")
    public String getBranchId() {
        return branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public DataAccount branchId(String branchId) {
        this.branchId = branchId;
        return this;
    }

    /**
     * Get bankName
     *
     * @return bankName
     **/
    @JsonProperty("bankName")
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public DataAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    /**
     * Get currency
     *
     * @return currency
     **/
    @JsonProperty("currency")
    public DataAccountCurrency getCurrency() {
        return currency;
    }

    public void setCurrency(DataAccountCurrency currency) {
        this.currency = currency;
    }

    public DataAccount currency(DataAccountCurrency currency) {
        this.currency = currency;
        return this;
    }

    @Override
    public String toString() {
        return "DataAccount ["
                + ((accountId != null) ? "accountId=" + accountId + ", " : "")
                + ((accountName != null) ? "accountName=" + accountName + ", " : "")
                + ((bankId != null) ? "bankId=" + bankId + ", " : "")
                + ((branchId != null) ? "branchId=" + branchId + ", " : "")
                + ((bankName != null) ? "bankName=" + bankName + ", " : "")
                + ((currency != null) ? "currency=" + currency : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataAccount that = (DataAccount) o;

        if (accountId != null ? !accountId.equals(that.accountId) : that.accountId != null) return false;
        if (accountName != null ? !accountName.equals(that.accountName) : that.accountName != null) return false;
        if (bankId != null ? !bankId.equals(that.bankId) : that.bankId != null) return false;
        if (branchId != null ? !branchId.equals(that.branchId) : that.branchId != null) return false;
        if (bankName != null ? !bankName.equals(that.bankName) : that.bankName != null) return false;
        return currency != null ? currency.equals(that.currency) : that.currency == null;
    }

    @Override
    public int hashCode() {
        int result = accountId != null ? accountId.hashCode() : 0;
        result = 31 * result + (accountName != null ? accountName.hashCode() : 0);
        result = 31 * result + (bankId != null ? bankId.hashCode() : 0);
        result = 31 * result + (branchId != null ? branchId.hashCode() : 0);
        result = 31 * result + (bankName != null ? bankName.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        return result;
    }
}

