package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account implements Serializable {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("currency-id")
    private Long currencyId;

    @JsonProperty("number")
    private String number;

    @JsonProperty("is-tax-exempt")
    private Boolean taxExempt;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Boolean getTaxExempt() {
        return taxExempt;
    }

    public void setTaxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    @Override
    public String toString() {
        return "Account [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((currencyId != null) ? "currencyId=" + currencyId + ", " : "") +
                ((number != null) ? "number='" + number + "', " : "") +
                ((taxExempt != null) ? "taxExempt=" + taxExempt + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Account account = (Account) o;
        return Objects.equals(id, account.id) && Objects.equals(currencyId, account.currencyId) && Objects.equals(number, account.number) && Objects.equals(taxExempt, account.taxExempt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, currencyId, number, taxExempt);
    }
}
