package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Agreement implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("agro-suppliers-subsidy")
    private BigDecimal agroSuppliersSubsidy;

    @JsonProperty("is-customer-pyme")
    private Boolean isCustomerPyme;

    @JsonProperty("product")
    private Product product;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getAgroSuppliersSubsidy() {
        return agroSuppliersSubsidy;
    }

    public void setAgroSuppliersSubsidy(BigDecimal agroSuppliersSubsidy) {
        this.agroSuppliersSubsidy = agroSuppliersSubsidy;
    }

    public Boolean getCustomerPyme() {
        return isCustomerPyme;
    }

    public void setCustomerPyme(Boolean customerPyme) {
        isCustomerPyme = customerPyme;
    }

    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public String toString() {
        return "Agreement [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((agroSuppliersSubsidy != null) ? "agroSuppliersSubsidy=" + agroSuppliersSubsidy + ", " : "") +
                ((isCustomerPyme != null) ? "isCustomerPyme=" + isCustomerPyme + ", " : "") +
                ((product != null) ? "product=" + product + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Agreement agreement = (Agreement) o;
        return Objects.equals(id, agreement.id) && Objects.equals(name, agreement.name) && Objects.equals(agroSuppliersSubsidy, agreement.agroSuppliersSubsidy) && Objects.equals(isCustomerPyme, agreement.isCustomerPyme) && Objects.equals(product, agreement.product);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, agroSuppliersSubsidy, isCustomerPyme, product);
    }
}