package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Application implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("customer")
    private Company company;

    @JsonProperty("start-date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date startDate;

    @JsonProperty("currency-id")
    private Long currencyId;

    @JsonProperty("amount")
    private BigDecimal amount;

    @JsonProperty("loan-amount")
    private BigDecimal loanAmount;

    @JsonProperty("disbursement-amount")
    private BigDecimal disbursementAmount;

    @JsonProperty("user")
    private String user;

    @JsonProperty("status")
    private Status status;

    @JsonProperty("has-detail")
    private Boolean hasDetail;

    @JsonProperty("distributor")
    private Company distributor;

    @JsonProperty("account")
    private Account account;

    @JsonProperty("category-name")
    private Status categoryName;

    public Company getDistributor() {
        return distributor;
    }

    public void setDistributor(Company distributor) {
        this.distributor = distributor;
    }

    public Boolean getHasDetail() {
        return hasDetail;
    }

    public void setHasDetail(Boolean hasDetail) {
        this.hasDetail = hasDetail;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public BigDecimal getDisbursementAmount() {
        return disbursementAmount;
    }

    public void setDisbursementAmount(BigDecimal disbursementAmount) {
        this.disbursementAmount = disbursementAmount;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getLoanAmount() {
        return loanAmount;
    }

    public void setLoanAmount(BigDecimal loanAmount) {
        this.loanAmount = loanAmount;
    }

    public Long getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Status getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(Status categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public String toString() {
        return "Application [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((company != null) ? "company=" + company + ", " : "") +
                ((startDate != null) ? "startDate=" + startDate + ", " : "") +
                ((currencyId != null) ? "currencyId=" + currencyId + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((loanAmount != null) ? "loanAmount=" + loanAmount + ", " : "") +
                ((disbursementAmount != null) ? "disbursementAmount=" + disbursementAmount + ", " : "") +
                ((user != null) ? "user='" + user + "', " : "") +
                ((status != null) ? "status=" + status + ", " : "") +
                ((hasDetail != null) ? "hasDetail=" + hasDetail + ", " : "") +
                ((distributor != null) ? "distributor=" + distributor + ", " : "") +
                ((account != null) ? "account=" + account + ", " : "") +
                ((categoryName != null) ? "categoryName=" + categoryName + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Application that = (Application) o;
        return Objects.equals(id, that.id) && Objects.equals(company, that.company) && Objects.equals(startDate, that.startDate) && Objects.equals(currencyId, that.currencyId) && Objects.equals(amount, that.amount) && Objects.equals(loanAmount, that.loanAmount) && Objects.equals(disbursementAmount, that.disbursementAmount) && Objects.equals(user, that.user) && Objects.equals(status, that.status) && Objects.equals(hasDetail, that.hasDetail) && Objects.equals(distributor, that.distributor) && Objects.equals(account, that.account) && Objects.equals(categoryName, that.categoryName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, company, startDate, currencyId, amount, loanAmount, disbursementAmount, user, status, hasDetail, distributor, account, categoryName);
    }
}