package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Product implements Serializable {

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("currency-id")
    private Long currencyId;

    @JsonProperty("start-time")
    @JsonDeserialize(using = LocalTimeDeserializer.class)
    private LocalTime startTime;

    @JsonProperty("end-time")
    @JsonDeserialize(using = LocalTimeDeserializer.class)
    private LocalTime endTime;

    @JsonProperty("min-amount")
    private BigDecimal minAmount;

    @JsonProperty("max-amount")
    private BigDecimal maxAmount;

    @JsonProperty("category-id")
    private Long categoryId;

    @JsonProperty("category-name")
    private String categoryName;

    @JsonProperty("term")
    private Long term;

    @JsonProperty("customer-nominal-annual-rate")
    private BigDecimal customerNominalAnnualRate;

    @JsonProperty("principal-payment")
    private String principalPayment;

    @JsonProperty("interest-payment")
    private String interestPayment;

    // Clase interna para deserializar LocalTime
    public static class LocalTimeDeserializer extends JsonDeserializer<LocalTime> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

        @Override
        public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return LocalTime.parse(p.getText(), FORMATTER);
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public LocalTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public BigDecimal getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(BigDecimal minAmount) {
        this.minAmount = minAmount;
    }

    public BigDecimal getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getTerm() {
        return term;
    }

    public void setTerm(Long term) {
        this.term = term;
    }

    public BigDecimal getCustomerNominalAnnualRate() {
        return customerNominalAnnualRate;
    }

    public void setCustomerNominalAnnualRate(BigDecimal customerNominalAnnualRate) {
        this.customerNominalAnnualRate = customerNominalAnnualRate;
    }

    public String getPrincipalPayment() {
        return principalPayment;
    }

    public void setPrincipalPayment(String principalPayment) {
        this.principalPayment = principalPayment;
    }

    public String getInterestPayment() {
        return interestPayment;
    }

    public void setInterestPayment(String interestPayment) {
        this.interestPayment = interestPayment;
    }

    @Override
    public String toString() {
        return "Product [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((name != null) ? "name='" + name + "', " : "") +
                ((currencyId != null) ? "currencyId=" + currencyId + ", " : "") +
                ((startTime != null) ? "startTime=" + startTime + ", " : "") +
                ((endTime != null) ? "endTime=" + endTime + ", " : "") +
                ((minAmount != null) ? "minAmount=" + minAmount + ", " : "") +
                ((maxAmount != null) ? "maxAmount=" + maxAmount + ", " : "") +
                ((categoryId != null) ? "categoryId=" + categoryId + ", " : "") +
                ((categoryName != null) ? "categoryName='" + categoryName + "', " : "") +
                ((term != null) ? "term=" + term + ", " : "") +
                ((customerNominalAnnualRate != null) ? "customerNominalAnnualRate=" + customerNominalAnnualRate + ", " : "") +
                ((principalPayment != null) ? "principalPayment='" + principalPayment + "', " : "") +
                ((interestPayment != null) ? "interestPayment='" + interestPayment + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Product product = (Product) o;
        return Objects.equals(id, product.id) && Objects.equals(name, product.name) && Objects.equals(currencyId, product.currencyId) && Objects.equals(startTime, product.startTime) && Objects.equals(endTime, product.endTime) && Objects.equals(minAmount, product.minAmount) && Objects.equals(maxAmount, product.maxAmount) && Objects.equals(categoryId, product.categoryId) && Objects.equals(categoryName, product.categoryName) && Objects.equals(term, product.term) && Objects.equals(customerNominalAnnualRate, product.customerNominalAnnualRate) && Objects.equals(principalPayment, product.principalPayment) && Objects.equals(interestPayment, product.interestPayment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, currencyId, startTime, endTime, minAmount, maxAmount, categoryId, categoryName, term, customerNominalAnnualRate, principalPayment, interestPayment);
    }
}