package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Simulation implements Serializable {

    @JsonProperty("term")
    private Long term;

    @JsonProperty("number-installments")
    private Integer numberInstallments;

    @JsonProperty("amortization-system")
    private String amortizationSystem;

    @JsonProperty("first-installment-date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date firstInstallmentDate;

    @JsonProperty("fixed-nominal-annual-rate")
    private BigDecimal fixedNominalAnnualRate;

    @JsonProperty("total-financial-cost")
    private BigDecimal totalFinancialCost;

    @JsonProperty("application-date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date applicationDate;

    @JsonProperty("usage-fee")
    private BigDecimal usageFee;

    @JsonProperty("rate-subsidy")
    private BigDecimal rateSubsidy;

    @JsonProperty("installment-details")
    private List<InstallmentDetails> installmentDetails;

    public Long getTerm() {
        return term;
    }

    public void setTerm(Long term) {
        this.term = term;
    }

    public Integer getNumberInstallments() {
        return numberInstallments;
    }

    public void setNumberInstallments(Integer numberInstallments) {
        this.numberInstallments = numberInstallments;
    }

    public String getAmortizationSystem() {
        return amortizationSystem;
    }

    public void setAmortizationSystem(String amortizationSystem) {
        this.amortizationSystem = amortizationSystem;
    }

    public Date getFirstInstallmentDate() {
        return firstInstallmentDate;
    }

    public void setFirstInstallmentDate(Date firstInstallmentDate) {
        this.firstInstallmentDate = firstInstallmentDate;
    }

    public BigDecimal getFixedNominalAnnualRate() {
        return fixedNominalAnnualRate;
    }

    public void setFixedNominalAnnualRate(BigDecimal fixedNominalAnnualRate) {
        this.fixedNominalAnnualRate = fixedNominalAnnualRate;
    }

    public BigDecimal getTotalFinancialCost() {
        return totalFinancialCost;
    }

    public void setTotalFinancialCost(BigDecimal totalFinancialCost) {
        this.totalFinancialCost = totalFinancialCost;
    }

    public Date getApplicationDate() {
        return applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public BigDecimal getUsageFee() {
        return usageFee;
    }

    public void setUsageFee(BigDecimal usageFee) {
        this.usageFee = usageFee;
    }

    public BigDecimal getRateSubsidy() {
        return rateSubsidy;
    }

    public void setRateSubsidy(BigDecimal rateSubsidy) {
        this.rateSubsidy = rateSubsidy;
    }

    public List<InstallmentDetails> getInstallmentDetails() {
        return installmentDetails;
    }

    public void setInstallmentDetails(List<InstallmentDetails> installmentDetails) {
        this.installmentDetails = installmentDetails;
    }

    @Override
    public String toString() {
        return "Simulation [" +
                ((term != null) ? "term=" + term + ", " : "") +
                ((numberInstallments != null) ? "numberInstallments=" + numberInstallments + ", " : "") +
                ((amortizationSystem != null) ? "amortizationSystem='" + amortizationSystem + "', " : "") +
                ((firstInstallmentDate != null) ? "firstInstallmentDate=" + firstInstallmentDate + ", " : "") +
                ((fixedNominalAnnualRate != null) ? "fixedNominalAnnualRate=" + fixedNominalAnnualRate + ", " : "") +
                ((totalFinancialCost != null) ? "totalFinancialCost=" + totalFinancialCost + ", " : "") +
                ((applicationDate != null) ? "applicationDate=" + applicationDate + ", " : "") +
                ((usageFee != null) ? "usageFee=" + usageFee + ", " : "") +
                ((rateSubsidy != null) ? "rateSubsidy=" + rateSubsidy + ", " : "") +
                ((installmentDetails != null) ? "installmentDetails=" + installmentDetails + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Simulation that = (Simulation) o;
        return Objects.equals(term, that.term) && Objects.equals(numberInstallments, that.numberInstallments) && Objects.equals(amortizationSystem, that.amortizationSystem) && Objects.equals(firstInstallmentDate, that.firstInstallmentDate) && Objects.equals(fixedNominalAnnualRate, that.fixedNominalAnnualRate) && Objects.equals(totalFinancialCost, that.totalFinancialCost) && Objects.equals(applicationDate, that.applicationDate) && Objects.equals(usageFee, that.usageFee) && Objects.equals(rateSubsidy, that.rateSubsidy) && Objects.equals(installmentDetails, that.installmentDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(term, numberInstallments, amortizationSystem, firstInstallmentDate, fixedNominalAnnualRate, totalFinancialCost, applicationDate, usageFee, rateSubsidy, installmentDetails);
    }
}