package ar.com.sdd.macroapi.io;

import ar.com.sdd.macroapi.model.Agreement;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetArrangementResponse implements Serializable {

    @JsonProperty("agreements")
    private List<Agreement> agreements;

    public List<Agreement> getAgreements() {
        return agreements;
    }

    public void setAgreements(List<Agreement> agreements) {
        this.agreements = agreements;
    }

    @Override
    public String toString() {
        return "GetArrangementResponse [" +
                ((agreements != null) ? "agreements=" + Arrays.toString(agreements.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetArrangementResponse that = (GetArrangementResponse) o;
        return Objects.equals(agreements, that.agreements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(agreements);
    }
}