package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Customer implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("key")
    private String key;

    @JsonProperty("accounts")
    private List<Account> accounts;

    @JsonProperty("legal-name")
    private String legalName;

    @JsonProperty("taxpayer-number")
    private String taxpayerNumber;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<Account> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }

    @Override
    public String toString() {
        return "Customer [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((key != null) ? "key='" + key + "', " : "") +
                ((accounts != null) ? "accounts=" + Arrays.toString(accounts.toArray()) + ", " : "") +
                ((legalName != null) ? "legalName='" + legalName + "', " : "") +
                ((taxpayerNumber != null) ? "taxpayerNumber='" + taxpayerNumber + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Customer customer = (Customer) o;
        return Objects.equals(name, customer.name) && Objects.equals(key, customer.key) && Objects.equals(accounts, customer.accounts) && Objects.equals(legalName, customer.legalName) && Objects.equals(taxpayerNumber, customer.taxpayerNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, key, accounts, legalName, taxpayerNumber);
    }
}