/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.macroapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.macroapi.core.MacroApiConnectorContext;
import ar.com.sdd.macroapi.io.CommonError;
import ar.com.sdd.macroapi.io.GetApplicationsResponse;
import ar.com.sdd.macroapi.io.GetArrangementResponse;
import ar.com.sdd.macroapi.io.GetCustomerAccountsResponse;
import ar.com.sdd.macroapi.io.GetOperationIdResponse;
import ar.com.sdd.macroapi.io.GetProductsResponse;
import ar.com.sdd.macroapi.io.GetSimulationResponse;
import ar.com.sdd.macroapi.io.GetSupplierAccountsResponse;
import ar.com.sdd.macroapi.io.PostApplicationRequest;
import ar.com.sdd.macroapi.io.PostApplicationResponse;
import ar.com.sdd.macroapi.io.PostAssessmentsResponse;
import ar.com.sdd.macroapi.io.PostAssessmentsValidateAmountRequest;
import ar.com.sdd.macroapi.io.PostAssessmentsValidateAmountResponse;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MacroApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(MacroApiConnector.class);
    private final RestConnector connector;
    private final String username;
    private final String password;
    private boolean doingLogin = false;
    private final boolean isSandbox;

    public MacroApiConnector(MacroApiConnectorContext context) {
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.isSandbox = context.isSandbox();
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public GetOperationIdResponse getOperationId() throws RestConnectorException {
        String path = "/v1/agro-loans/operations-id";
        log.debug("[getOperationId] Request GET por pedir un id de operacion con path [{}]", (Object)"/v1/agro-loans/operations-id");
        return (GetOperationIdResponse)this.connector.genericGet(null, GetOperationIdResponse.class, CommonError.class, "/v1/agro-loans/operations-id");
    }

    public GetCustomerAccountsResponse getCustomerAccounts(String operationId, String customerTaxPayerNumber, String distributorTaxPayerNumber, Long currencyId) throws RestConnectorException {
        String path = "/v1/agro-loans/accounts/taxpayer-numbers/" + customerTaxPayerNumber + "?operation-id=" + operationId + "&currency-id=" + currencyId;
        if (StringUtil.isNotEmpty((String)distributorTaxPayerNumber)) {
            path = path + "&distributor-taxpayer-number=" + distributorTaxPayerNumber;
        }
        log.debug("[getCustomerAccounts] Request GET por pedir las cuentas del cliente con path [{}]", (Object)path);
        return (GetCustomerAccountsResponse)this.connector.genericGet(null, GetCustomerAccountsResponse.class, CommonError.class, path);
    }

    public PostAssessmentsResponse postAssessmentsAvailability(String operationId, String customerKey, Long accountId, String userIdentity) throws RestConnectorException {
        String path = "/v1/agro-loans/assessments/customers/" + customerKey + "/availability?operation-id=" + operationId + "&account-id=" + accountId + "&user-identity=" + userIdentity;
        log.debug("[postAssessments] Request POST por crear un assessment con path [{}]", (Object)path);
        return (PostAssessmentsResponse)this.connector.genericPost(null, PostAssessmentsResponse.class, CommonError.class, path);
    }

    public GetProductsResponse getProducts(String operationId, String customerKey) throws RestConnectorException {
        String path = "/v1/agro-loans/products/customers/" + customerKey + "?operation-id=" + operationId;
        log.debug("[getProducts] Request GET por pedir productos con path [{}]", (Object)path);
        return (GetProductsResponse)this.connector.genericGet(null, GetProductsResponse.class, CommonError.class, path);
    }

    public GetSupplierAccountsResponse getSupplierAccounts(String operationId, Long currencyId) throws RestConnectorException {
        String path = "/v1/agro-loans/supplier/accounts?operation-id=" + operationId + "&currency-id=" + currencyId;
        log.debug("[getSupplierAccounts] Request GET por pedir cuentas de la insumera (biller) con path [{}]", (Object)path);
        return (GetSupplierAccountsResponse)this.connector.genericGet(null, GetSupplierAccountsResponse.class, CommonError.class, path);
    }

    public PostAssessmentsValidateAmountResponse postAssessmentsValidateAmount(String operationId, String customerKey, PostAssessmentsValidateAmountRequest postAssessmentsValidateAmountRequest) throws RestConnectorException {
        String path = "/v1/agro-loans/assessments/customers/" + customerKey + "/validate-amount?operation-id=" + operationId;
        log.debug("[postAssessmentsValidateAmount] Request POST por validar importes del prestamo con request [{}] y path [{}]", (Object)postAssessmentsValidateAmountRequest, (Object)path);
        return (PostAssessmentsValidateAmountResponse)this.connector.genericPost((Object)postAssessmentsValidateAmountRequest, PostAssessmentsValidateAmountResponse.class, CommonError.class, path);
    }

    public Void postParameters(String operationId, String customerKey, Long currencyId) throws RestConnectorException {
        String path = "/v1/agro-loans/parameters/customers/" + customerKey + "/product-currencies/" + currencyId + "?operation-id=" + operationId;
        log.debug("[postParameters] Request POST por settear parametros del prestamo con path [{}]", (Object)path);
        return (Void)this.connector.genericPost(null, Void.class, CommonError.class, path);
    }

    public GetArrangementResponse getArrangement(String operationId, String customerKey, Long productCategoryId) throws RestConnectorException {
        String path = "/v1/agro-loans/arrangement/customers/" + customerKey + "?operation-id=" + operationId + "&product-category-id=" + productCategoryId;
        log.debug("[getArrangementResponse] Request GET por pedir convenios disponibles con path [{}]", (Object)path);
        return (GetArrangementResponse)this.connector.genericGet(null, GetArrangementResponse.class, CommonError.class, path);
    }

    public GetSimulationResponse getSimulation(String operationId, String customerKey, Long arrangementId) throws RestConnectorException {
        String path = "/v1/agro-loans/simulation/customers-id/" + customerKey + "?operation-id=" + operationId + "&arrangment-id=" + arrangementId;
        log.debug("[getSimulationResponse] Request GET por pedir simulacion con path [{}]", (Object)path);
        return (GetSimulationResponse)this.connector.genericGet(null, GetSimulationResponse.class, CommonError.class, path);
    }

    public PostApplicationResponse postApplication(String operationId, String customerKey, PostApplicationRequest postApplicationRequest) throws RestConnectorException {
        String path = "/v1/agro-loans/applications/customers-id/" + customerKey + "?operation-id=" + operationId;
        log.debug("[postApplication] Request POST por generar prestamo con request [{}] y path [{}]", (Object)postApplicationRequest, (Object)path);
        return (PostApplicationResponse)this.connector.genericPost((Object)postApplicationRequest, PostApplicationResponse.class, CommonError.class, path);
    }

    public GetApplicationsResponse getApplications(String operationId, String customerTaxPayerNumber, String distributorTaxPayerNumber, FilterOptions filterOptions, List<Long> productCategoriesIds, Status statusId, Date dateFrom, Date dateTo, String orderBy, String order, Integer page, Integer recordsNumber) throws RestConnectorException {
        String path = "/v1/agro-loans/applications?operation-id=" + operationId;
        if (StringUtil.isNotEmpty((String)customerTaxPayerNumber)) {
            path = path + "&customer-taxpayer-number=" + customerTaxPayerNumber;
        }
        if (StringUtil.isNotEmpty((String)distributorTaxPayerNumber)) {
            path = path + "&distributor-taxpayer-number=" + distributorTaxPayerNumber;
        }
        if (filterOptions != null) {
            path = path + "&filter-options=" + filterOptions.value;
        }
        if (CollectionUtils.isNotEmpty(productCategoriesIds)) {
            path = path + "&product-categories-ids=" + productCategoriesIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (statusId != null) {
            path = path + "&status-id=" + statusId.name();
        }
        if (dateFrom != null) {
            path = path + "&date-from=" + DateUtil.formatJsonDate((Date)dateFrom);
        }
        if (dateTo != null) {
            path = path + "&date-to=" + DateUtil.formatJsonDate((Date)dateTo);
        }
        if (StringUtil.isNotEmpty((String)orderBy)) {
            path = path + "&order-by=" + orderBy;
        }
        if (StringUtil.isNotEmpty((String)order)) {
            path = path + "&order=" + order;
        }
        if (page != null) {
            path = path + "&page=" + page;
        }
        if (recordsNumber != null) {
            path = path + "&records-number=" + recordsNumber;
        }
        log.debug("[getApplications] Request GET por pedir aplicaciones con path [{}]", (Object)path);
        return (GetApplicationsResponse)this.connector.genericGet(null, GetApplicationsResponse.class, CommonError.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            if (this.doingLogin) {
                builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)this.username, (String)this.password));
            } else {
                builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
                if (this.isSandbox) {
                    builder.header("x-request-id", (Object)"f61c2780-1f91-48f8-aed7-e687b4c617df");
                }
            }
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        if (!this.doingLogin) {
            try {
                this.getAccessToken(true);
                return true;
            }
            catch (RestConnectorException e) {
                log.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(MacroApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("scope", "openid");
            form.param("grant_type", "client_credentials");
            log.debug("[getAccessToken] Por obtener token con username [{}] y password [{}]", (Object)this.username, (Object)this.password);
            this.doingLogin = true;
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)this.connector.genericPost((Object)form, TokenOAuth2.class, CommonError.class, "/v1/oauth/token", "application/json", "application/x-www-form-urlencoded");
            this.doingLogin = false;
            accessToken = tokenOAuth2Response.getAccessToken();
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", (Object)accessToken, (Object)tokenOAuth2Response.getExpiresIn());
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }

    public static enum Status {
        ACEPTADA,
        ERROR,
        EXPIRADA,
        LIQUIDADA,
        PENDIENTE,
        RECHAZADA,
        REVERSADA;

    }

    public static enum FilterOptions {
        ALL("ALL"),
        DISTRIBUTOR("DISTRIBUTOR"),
        AGRO_SUPPLIER("AGRO-SUPPLIER");

        private final String value;

        private FilterOptions(String value) {
            this.value = value;
        }
    }
}

