package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AmountValidationResult implements Serializable {

    @JsonProperty("is-authorize")
    private Boolean isAuthorize;

    @JsonProperty("is-below-minimum")
    private Boolean isBelowMinimum;

    @JsonProperty("is-above-maximum")
    private Boolean isAboveMaximum;

    public Boolean getAuthorize() {
        return isAuthorize;
    }

    public void setAuthorize(Boolean authorize) {
        isAuthorize = authorize;
    }

    public Boolean getBelowMinimum() {
        return isBelowMinimum;
    }

    public void setBelowMinimum(Boolean belowMinimum) {
        isBelowMinimum = belowMinimum;
    }

    public Boolean getAboveMaximum() {
        return isAboveMaximum;
    }

    public void setAboveMaximum(Boolean aboveMaximum) {
        isAboveMaximum = aboveMaximum;
    }

    @Override
    public String toString() {
        return "AmountValidationResult [" +
                ((isAuthorize != null) ? "isAuthorize=" + isAuthorize + ", " : "") +
                ((isBelowMinimum != null) ? "isBelowMinimum=" + isBelowMinimum + ", " : "") +
                ((isAboveMaximum != null) ? "isAboveMaximum=" + isAboveMaximum + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AmountValidationResult that = (AmountValidationResult) o;
        return Objects.equals(isAuthorize, that.isAuthorize) && Objects.equals(isBelowMinimum, that.isBelowMinimum) && Objects.equals(isAboveMaximum, that.isAboveMaximum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isAuthorize, isBelowMinimum, isAboveMaximum);
    }
}