package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstallmentDetails implements Serializable {

    @JsonProperty("arrangment-name")
    private String arrangmentName;

    @JsonProperty("installment-due-date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date installmentDueDate;

    @JsonProperty("principal-amount")
    private BigDecimal principalAmount;

    @JsonProperty("interest-amount")
    private BigDecimal interestAmount;

    @JsonProperty("iva-amount")
    private BigDecimal ivaAmount;

    @JsonProperty("total-installment-amount")
    private BigDecimal totalInstallmentAmount;

    public String getArrangmentName() {
        return arrangmentName;
    }

    public void setArrangmentName(String arrangmentName) {
        this.arrangmentName = arrangmentName;
    }

    public Date getInstallmentDueDate() {
        return installmentDueDate;
    }

    public void setInstallmentDueDate(Date installmentDueDate) {
        this.installmentDueDate = installmentDueDate;
    }

    public BigDecimal getPrincipalAmount() {
        return principalAmount;
    }

    public void setPrincipalAmount(BigDecimal principalAmount) {
        this.principalAmount = principalAmount;
    }

    public BigDecimal getInterestAmount() {
        return interestAmount;
    }

    public void setInterestAmount(BigDecimal interestAmount) {
        this.interestAmount = interestAmount;
    }

    public BigDecimal getIvaAmount() {
        return ivaAmount;
    }

    public void setIvaAmount(BigDecimal ivaAmount) {
        this.ivaAmount = ivaAmount;
    }

    public BigDecimal getTotalInstallmentAmount() {
        return totalInstallmentAmount;
    }

    public void setTotalInstallmentAmount(BigDecimal totalInstallmentAmount) {
        this.totalInstallmentAmount = totalInstallmentAmount;
    }

    @Override
    public String toString() {
        return "InstallmentDetails [" +
                ((arrangmentName != null) ? "arrangmentName='" + arrangmentName + "', " : "") +
                ((installmentDueDate != null) ? "installmentDueDate=" + installmentDueDate + ", " : "") +
                ((principalAmount != null) ? "principalAmount=" + principalAmount + ", " : "") +
                ((interestAmount != null) ? "interestAmount=" + interestAmount + ", " : "") +
                ((ivaAmount != null) ? "ivaAmount=" + ivaAmount + ", " : "") +
                ((totalInstallmentAmount != null) ? "totalInstallmentAmount=" + totalInstallmentAmount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InstallmentDetails that = (InstallmentDetails) o;
        return Objects.equals(arrangmentName, that.arrangmentName) && Objects.equals(installmentDueDate, that.installmentDueDate) && Objects.equals(principalAmount, that.principalAmount) && Objects.equals(interestAmount, that.interestAmount) && Objects.equals(ivaAmount, that.ivaAmount) && Objects.equals(totalInstallmentAmount, that.totalInstallmentAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(arrangmentName, installmentDueDate, principalAmount, interestAmount, ivaAmount, totalInstallmentAmount);
    }
}