package ar.com.sdd.macroapi.io;

import ar.com.sdd.macroapi.model.Application;
import ar.com.sdd.macroapi.model.Simulation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetSimulationResponse implements Serializable {

    @JsonProperty("application")
    private Application application;

    @JsonProperty("simulation")
    private Simulation simulation;

    public Application getApplication() {
        return application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Simulation getSimulation() {
        return simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    @Override
    public String toString() {
        return "GetSimulationResponse [" +
                ((application != null) ? "application=" + application + ", " : "") +
                ((simulation != null) ? "simulation=" + simulation + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetSimulationResponse that = (GetSimulationResponse) o;
        return Objects.equals(application, that.application) && Objects.equals(simulation, that.simulation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(application, simulation);
    }
}