package ar.com.sdd.macroapi.io;

import com.fasterxml.jackson.annotation.*;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostApplicationRequest implements Serializable {

    @JsonProperty("arrangment-id")
    private Long arrangmentId;

    @JsonProperty("user-identity")
    private String userIdentity;

    @JsonProperty("distributor-taxpayer-number")
    private String distributorTaxpayerNumber;

    @JsonProperty("observations")
    private String observations;

     public Long getArrangmentId() {
          return arrangmentId;
     }

     @JsonGetter("arrangment-id")
     public String getArrangmentIdAsString() {
          return arrangmentId != null ? arrangmentId.toString() : null;
     }

    public void setArrangmentId(Long arrangmentId) {
        this.arrangmentId = arrangmentId;
    }

     @JsonSetter("arrangment-id")
     public void setArrangmentIdAsString(String arrangmentId) {
         if (arrangmentId != null) setArrangmentId(Long.valueOf(arrangmentId));
     }

     public String getUserIdentity() {
          return userIdentity;
     }

     public void setUserIdentity(String userIdentity) {
          this.userIdentity = userIdentity;
     }

     public String getDistributorTaxpayerNumber() {
          return distributorTaxpayerNumber;
     }

     public void setDistributorTaxpayerNumber(String distributorTaxpayerNumber) {
          this.distributorTaxpayerNumber = distributorTaxpayerNumber;
     }

     public String getObservations() {
          return observations;
     }

     public void setObservations(String observations) {
          this.observations = observations;
     }

     @Override
     public String toString() {
          return "PostApplicationRequest [" +
                  ((arrangmentId != null) ? "arrangmentId='" + arrangmentId + "', " : "") +
                  ((userIdentity != null) ? "userIdentity='" + userIdentity + "', " : "") +
                  ((distributorTaxpayerNumber != null) ? "distributorTaxpayerNumber='" + distributorTaxpayerNumber + "', " : "") +
                  ((observations != null) ? "observations='" + observations + "', " : "") +
                  "]";
     }

     @Override
     public boolean equals(Object o) {
          if (this == o) return true;
          if (o == null || getClass() != o.getClass()) return false;
          PostApplicationRequest that = (PostApplicationRequest) o;
          return Objects.equals(arrangmentId, that.arrangmentId) && Objects.equals(userIdentity, that.userIdentity) && Objects.equals(distributorTaxpayerNumber, that.distributorTaxpayerNumber) && Objects.equals(observations, that.observations);
     }

     @Override
     public int hashCode() {
          return Objects.hash(arrangmentId, userIdentity, distributorTaxpayerNumber, observations);
     }
}