package ar.com.sdd.macroapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostApplicationResponse implements Serializable {

    @JsonProperty("application-id")
    private String applicationId;

    @JsonProperty("status-description")
    private String statusDescription;

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    @Override
    public String toString() {
        return "PostApplicationResponse [" +
                ((applicationId != null) ? "applicationId='" + applicationId + "', " : "") +
                ((statusDescription != null) ? "statusDescription='" + statusDescription + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostApplicationResponse that = (PostApplicationResponse) o;
        return Objects.equals(applicationId, that.applicationId) && Objects.equals(statusDescription, that.statusDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationId, statusDescription);
    }
}