package ar.com.sdd.macroapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAssessmentsResponse implements Serializable {

    @JsonProperty("is-credit-available")
    private Boolean creditAvailable;

    @JsonProperty("is-max-attempts")
    private Boolean maxAttempts;

    public Boolean getCreditAvailable() {
        return creditAvailable;
    }

    public void setCreditAvailable(Boolean creditAvailable) {
        this.creditAvailable = creditAvailable;
    }

    public Boolean getMaxAttempts() {
        return maxAttempts;
    }

    public void setMaxAttempts(Boolean maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Override
    public String
    toString() {
        return "PostAssessmentsResponse [" +
                ((creditAvailable != null) ? "creditAvailable=" + creditAvailable + ", " : "") +
                ((maxAttempts != null) ? "maxAttempts=" + maxAttempts + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAssessmentsResponse that = (PostAssessmentsResponse) o;
        return Objects.equals(creditAvailable, that.creditAvailable) && Objects.equals(maxAttempts, that.maxAttempts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creditAvailable, maxAttempts);
    }
}