package ar.com.sdd.macroapi.io;

import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.macroapi.model.Product;
import com.fasterxml.jackson.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAssessmentsValidateAmountRequest implements Serializable {

    @JsonProperty("loan-amount")
    private String loanAmount;

    @JsonProperty("user-identity")
    private String userIdentity;

    @JsonProperty("product")
    private Product product;

    @JsonGetter("loan-amount")
    public String getLoanAmountAsString() {
        return loanAmount;
    }

    @JsonSetter("loan-amount")
    public void setLoanAmountAsString(String loanAmount) {
        this.loanAmount = loanAmount;
    }

    public BigDecimal getLoanAmount() {
        return loanAmount != null ? NumberUtil.newBigDecimal(loanAmount) : null;
    }

    public void setLoanAmount(BigDecimal loanAmount) {
        if (loanAmount != null) {
            setLoanAmountAsString(loanAmount.toString());
        }
    }

    public String getUserIdentity() {
        return userIdentity;
    }

    public void setUserIdentity(String userIdentity) {
        this.userIdentity = userIdentity;
    }

    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public String toString() {
        return "PostAssessmentsValidateAmountRequest [" +
                ((loanAmount != null) ? "loanAmount='" + loanAmount + "', " : "") +
                ((userIdentity != null) ? "userIdentity='" + userIdentity + "', " : "") +
                ((product != null) ? "product=" + product + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAssessmentsValidateAmountRequest that = (PostAssessmentsValidateAmountRequest) o;
        return Objects.equals(loanAmount, that.loanAmount) && Objects.equals(userIdentity, that.userIdentity) && Objects.equals(product, that.product);
    }

    @Override
    public int hashCode() {
        return Objects.hash(loanAmount, userIdentity, product);
    }
}