package ar.com.sdd.macroapi.io;

import ar.com.sdd.macroapi.model.AmountValidationResult;
import ar.com.sdd.macroapi.model.Attempt;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAssessmentsValidateAmountResponse implements Serializable {

    @JsonProperty("amount")
    private AmountValidationResult amountValidationResult;

    @JsonProperty("attempts")
    private Attempt attempt;

    public AmountValidationResult getAmountValidationResult() {
        return amountValidationResult;
    }

    public void setAmountValidationResult(AmountValidationResult amountValidationResult) {
        this.amountValidationResult = amountValidationResult;
    }

    public Attempt getAttempt() {
        return attempt;
    }

    public void setAttempt(Attempt attempt) {
        this.attempt = attempt;
    }

    @Override
    public String toString() {
        return "PostAssessmentsValidateAmountResponse [" +
                ((amountValidationResult != null) ? "amountValidationResult=" + amountValidationResult + ", " : "") +
                ((attempt != null) ? "attempt=" + attempt + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAssessmentsValidateAmountResponse that = (PostAssessmentsValidateAmountResponse) o;
        return Objects.equals(amountValidationResult, that.amountValidationResult) && Objects.equals(attempt, that.attempt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amountValidationResult, attempt);
    }
}