package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Attempt implements Serializable {

    @JsonProperty("number")
    private Long number;

    @JsonProperty("remaining")
    private Long remaining;

    @JsonProperty("is-available")
    private Boolean isAvailable;

    public Long getNumber() {
        return number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public Long getRemaining() {
        return remaining;
    }

    public void setRemaining(Long remaining) {
        this.remaining = remaining;
    }

    public Boolean getAvailable() {
        return isAvailable;
    }

    public void setAvailable(Boolean available) {
        isAvailable = available;
    }

    @Override
    public String toString() {
        return "Attempt [" +
                ((number != null) ? "number=" + number + ", " : "") +
                ((remaining != null) ? "remaining=" + remaining + ", " : "") +
                ((isAvailable != null) ? "isAvailable=" + isAvailable + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Attempt attempt = (Attempt) o;
        return Objects.equals(number, attempt.number) && Objects.equals(remaining, attempt.remaining) && Objects.equals(isAvailable, attempt.isAvailable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, remaining, isAvailable);
    }
}