package ar.com.sdd.macroapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Company implements Serializable {

    @JsonProperty("taxpayer-number")
    private String taxPayerNumber;

    @JsonProperty("legal-name")
    private String legalName;

    public String getTaxPayerNumber() {
        return taxPayerNumber;
    }

    public void setTaxPayerNumber(String taxPayerNumber) {
        this.taxPayerNumber = taxPayerNumber;
    }

    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    @Override
    public String toString() {
        return "Company [" +
                ((taxPayerNumber != null) ? "taxPayerNumber='" + taxPayerNumber + "', " : "") +
                ((legalName != null) ? "legalName='" + legalName + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Company company = (Company) o;
        return Objects.equals(taxPayerNumber, company.taxPayerNumber) && Objects.equals(legalName, company.legalName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxPayerNumber, legalName);
    }
}