package ar.com.sdd.macroapi.model;

import ar.com.sdd.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Currency {

    ARS(80L, "Pesos", "ARS"),
    USD(2L, "Dolares", "USD");

    private final Long code;
    private final String desc;
    private final String ebfCode;

    Currency(Long code, String desc, String ebfCode) {
        this.code = code;
        this.desc = desc;
        this.ebfCode = ebfCode;
    }

    @JsonCreator
    public static Currency forValue(Long code) {
        if (code == null) {
            return null;
        }
        for (Currency currency : Currency.values()) {
            if (currency.code.equals(code)) {
                return currency;
            }
        }
        throw new RuntimeException("No existe la moneda para el codigo [" + code + "]");
    }

    public static Currency forValueEbf(String ebfCode) {
        if (StringUtil.isEmpty(ebfCode)) {
            return null;
        }
        for (Currency moneda : Currency.values()) {
            if (moneda.ebfCode.equals(ebfCode)) {
                return moneda;
            }
        }
        throw new RuntimeException("No existe la moneda para el codigo ebf [" + ebfCode + "]");
    }

    public Long getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getEbfCode() {
        return ebfCode;
    }

    @JsonValue
    public Long toValue() {
        return this.code;
    }
}