/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.macroapi.model;

import ar.com.sdd.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Currency {
    ARS(80L, "Pesos", "ARS"),
    USD(2L, "Dolares", "USD");

    private final Long code;
    private final String desc;
    private final String ebfCode;

    private Currency(Long code, String desc, String ebfCode) {
        this.code = code;
        this.desc = desc;
        this.ebfCode = ebfCode;
    }

    @JsonCreator
    public static Currency forValue(Long code) {
        if (code == null) {
            return null;
        }
        for (Currency currency : Currency.values()) {
            if (!currency.code.equals(code)) continue;
            return currency;
        }
        throw new RuntimeException("No existe la moneda para el codigo [" + code + "]");
    }

    public static Currency forValueEbf(String ebfCode) {
        if (StringUtil.isEmpty((String)ebfCode)) {
            return null;
        }
        for (Currency moneda : Currency.values()) {
            if (!moneda.ebfCode.equals(ebfCode)) continue;
            return moneda;
        }
        throw new RuntimeException("No existe la moneda para el codigo ebf [" + ebfCode + "]");
    }

    public Long getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEbfCode() {
        return this.ebfCode;
    }

    @JsonValue
    public Long toValue() {
        return this.code;
    }
}

