/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.macroapi.model;

import ar.com.sdd.macroapi.model.Currency;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Product
implements Serializable {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="currency-id")
    private Currency currencyId;
    @JsonProperty(value="start-time")
    @JsonDeserialize(using=LocalTimeDeserializer.class)
    private LocalTime startTime;
    @JsonProperty(value="end-time")
    @JsonDeserialize(using=LocalTimeDeserializer.class)
    private LocalTime endTime;
    @JsonProperty(value="min-amount")
    private BigDecimal minAmount;
    @JsonProperty(value="max-amount")
    private BigDecimal maxAmount;
    @JsonProperty(value="category-id")
    private Long categoryId;
    @JsonProperty(value="category-name")
    private String categoryName;
    @JsonProperty(value="term")
    private Integer term;
    @JsonProperty(value="customer-nominal-annual-rate")
    private BigDecimal customerNominalAnnualRate;
    @JsonProperty(value="principal-payment")
    private String principalPayment;
    @JsonProperty(value="interest-payment")
    private String interestPayment;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Currency getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Currency currencyId) {
        this.currencyId = currencyId;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public BigDecimal getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(BigDecimal minAmount) {
        this.minAmount = minAmount;
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Integer getTerm() {
        return this.term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public BigDecimal getCustomerNominalAnnualRate() {
        return this.customerNominalAnnualRate;
    }

    public void setCustomerNominalAnnualRate(BigDecimal customerNominalAnnualRate) {
        this.customerNominalAnnualRate = customerNominalAnnualRate;
    }

    public String getPrincipalPayment() {
        return this.principalPayment;
    }

    public void setPrincipalPayment(String principalPayment) {
        this.principalPayment = principalPayment;
    }

    public String getInterestPayment() {
        return this.interestPayment;
    }

    public void setInterestPayment(String interestPayment) {
        this.interestPayment = interestPayment;
    }

    public String toString() {
        return "Product [" + (String)(this.id != null ? "id='" + this.id + "', " : "") + (String)(this.name != null ? "name='" + this.name + "', " : "") + (String)(this.currencyId != null ? "currencyId=" + this.currencyId + ", " : "") + (String)(this.startTime != null ? "startTime=" + this.startTime + ", " : "") + (String)(this.endTime != null ? "endTime=" + this.endTime + ", " : "") + (String)(this.minAmount != null ? "minAmount=" + this.minAmount + ", " : "") + (String)(this.maxAmount != null ? "maxAmount=" + this.maxAmount + ", " : "") + (String)(this.categoryId != null ? "categoryId=" + this.categoryId + ", " : "") + (String)(this.categoryName != null ? "categoryName='" + this.categoryName + "', " : "") + (String)(this.term != null ? "term=" + this.term + ", " : "") + (String)(this.customerNominalAnnualRate != null ? "customerNominalAnnualRate=" + this.customerNominalAnnualRate + ", " : "") + (String)(this.principalPayment != null ? "principalPayment='" + this.principalPayment + "', " : "") + (String)(this.interestPayment != null ? "interestPayment='" + this.interestPayment + "', " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.id, product.id) && Objects.equals(this.name, product.name) && Objects.equals((Object)this.currencyId, (Object)product.currencyId) && Objects.equals(this.startTime, product.startTime) && Objects.equals(this.endTime, product.endTime) && Objects.equals(this.minAmount, product.minAmount) && Objects.equals(this.maxAmount, product.maxAmount) && Objects.equals(this.categoryId, product.categoryId) && Objects.equals(this.categoryName, product.categoryName) && Objects.equals(this.term, product.term) && Objects.equals(this.customerNominalAnnualRate, product.customerNominalAnnualRate) && Objects.equals(this.principalPayment, product.principalPayment) && Objects.equals(this.interestPayment, product.interestPayment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.currencyId, this.startTime, this.endTime, this.minAmount, this.maxAmount, this.categoryId, this.categoryName, this.term, this.customerNominalAnnualRate, this.principalPayment, this.interestPayment});
    }

    public static class LocalTimeDeserializer
    extends JsonDeserializer<LocalTime> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

        public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return LocalTime.parse(p.getText(), FORMATTER);
        }
    }
}

