/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.app;

import ar.com.sdd.commons.util.ApplicationException;
import ar.com.sdd.marketsim.HomeManager;
import ar.com.sdd.marketsim.Initializer;
import ar.com.sdd.marketsim.exception.NotInitializedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Application {
    private static final Logger log = LogManager.getLogger(Application.class);
    protected static Application instance = null;
    protected boolean initialized = false;

    public static Application createInstance() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public static Application getInstance() {
        if (instance == null) {
            throw new NotInitializedException(Application.class);
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null && Application.instance.initialized;
    }

    public synchronized void initialize() throws ApplicationException {
        if (!this.initialized) {
            HomeManager aHome;
            log.info("Inicializando aplicacion...");
            String homeManagerClassName = "ar.com.sdd.marketsim.HomeManager";
            log.info("Cargando el HomeManager: {}", (Object)homeManagerClassName);
            try {
                aHome = (HomeManager)Class.forName(homeManagerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception cfnE) {
                log.error((Object)cfnE);
                throw new NotInitializedException(Initializer.class);
            }
            log.info("Inicializando el HomeManager .... ");
            HomeManager.initialize(aHome);
            log.info("HomeManager inicializado");
            log.info("Aplicacion inicializada con exito.");
            this.initialized = true;
        }
    }
}

