/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.bo.operator;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.marketsim.bo.operator.Operator;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity(name="Operator")
@Table(name="OPERATORS")
public class OperatorBean
implements Operator,
Serializable {
    public static final String SEQUENCER_SEQ_NAME = "seq_operators";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_operators")
    @SequenceGenerator(name="seq_operators", sequenceName="seq_operators", allocationSize=1)
    private Long id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=false)
    private String description;
    private String password;
    private boolean enabled;
    @Column(name="CREATION_TIMESTAMP", nullable=false, updatable=false)
    private LocalDateTime creationTimestamp;

    @PrePersist
    protected void onCreate() {
        this.creationTimestamp = LocalDateTime.now();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public LocalDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public void setCreationTimestamp(LocalDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @Override
    public boolean validatePassword(String password) {
        return StringUtil.isEmpty((String)this.password) || this.password.equals(password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorBean that = (OperatorBean)o;
        return this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.password, that.password) && Objects.equals(this.creationTimestamp, that.creationTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.password, this.enabled, this.creationTimestamp);
    }

    public String toString() {
        return "OperatorBean [" + (String)(this.id != null ? "id=" + this.id + ", " : "") + (String)(this.name != null ? "name='" + this.name + "', " : "") + (String)(this.description != null ? "description='" + this.description + "', " : "") + (String)(this.password != null ? "password='" + this.password + "', " : "") + "enabled=" + this.enabled + ", " + (String)(this.creationTimestamp != null ? "creationTimestamp=" + this.creationTimestamp + ", " : "") + "]";
    }
}

