/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.commandprocessor;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.util.PasswordUtil;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.marketsim.ApiResponseMessage;
import ar.com.sdd.marketsim.CommandRequest;
import ar.com.sdd.marketsim.HomeManager;
import ar.com.sdd.marketsim.InitalizerSmall;
import ar.com.sdd.marketsim.Marketsim;
import ar.com.sdd.marketsim.bo.operator.Operator;
import ar.com.sdd.marketsim.bo.operator.OperatorBean;
import ar.com.sdd.marketsim.bo.operator.OperatorHome;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="/")
public class CommandProcessorApiEndpoint {
    private static final Logger log = LogManager.getLogger(CommandProcessorApiEndpoint.class);
    final List<String> widgetCommands = List.of("help", "SD", "ST", "TEL", "LS", "CT", "RM", "CMT", "CEV", "AEV", "EV", "DEL", "OUT", "GT", "RE", "RPT", "EX", "DB");
    final Marketsim ms = new Marketsim();
    private static boolean marketsimInitialized = false;

    @POST
    @ServerFileLogged
    @Path(value="/processCommand")
    @Produces(value={"application/json; charset=utf-8"})
    @Consumes(value={"application/json; charset=utf-8"})
    public Response processCommand(CommandRequest commandRequest) {
        ApiResponseMessage apiResponseMessage;
        String[] commandParts;
        String commandName;
        if (!marketsimInitialized) {
            new InitalizerSmall();
            marketsimInitialized = true;
        }
        if (StringUtil.isEmpty((String)(commandName = StringUtil.nonNull((String)(commandParts = StringUtil.split((String)commandRequest.getCommandToProcess(), (char)' ', (int)1))[0])))) {
            apiResponseMessage = new ApiResponseMessage(1, "Command empty", false);
        } else if (commandName.equals("login")) {
            String userId;
            String string = userId = commandParts.length > 1 ? commandParts[1] : null;
            apiResponseMessage = StringUtil.isEmpty((String)userId) ? new ApiResponseMessage(4, "User " + userId + " logged successfully", this.determineIfWidget(commandName)) : new ApiResponseMessage(4, this.doLogin(userId) ? "User " + userId + " logged successfully" : "User " + userId + " not logged in", this.determineIfWidget(commandName));
        } else if (commandName.equals("createuser")) {
            String userName = null;
            String userDescription = null;
            String userPassword = null;
            boolean userEnabled = true;
            for (int n = 1; n < commandParts.length; ++n) {
                String commandArg = StringUtil.nonNull((String)commandParts[n]);
                if (commandArg.equals("-name")) {
                    userName = commandParts[++n];
                }
                if (commandArg.equals("-description")) {
                    userDescription = commandParts[++n];
                }
                if (commandArg.equals("-password")) {
                    userPassword = commandParts[++n];
                }
                if (!commandArg.equals("-enabled")) continue;
                userEnabled = Boolean.parseBoolean(commandParts[++n]);
            }
            if (StringUtil.isEmpty(userName)) {
                apiResponseMessage = new ApiResponseMessage(1, "Command createuser requires -name argument", false);
            } else if (StringUtil.isEmpty(userDescription)) {
                apiResponseMessage = new ApiResponseMessage(1, "Command createuser requires -description argument", false);
            } else {
                OperatorHome operatorHome = HomeManager.getInstance().getOperatorHome();
                Operator existingOperator = null;
                try {
                    existingOperator = operatorHome.findByName(userName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (existingOperator == null) {
                    OperatorBean newOperator = new OperatorBean();
                    newOperator.setName(userName);
                    newOperator.setDescription(userDescription);
                    if (StringUtil.isNotEmpty((String)userPassword)) {
                        userPassword = PasswordUtil.getInstance().hashPassword(userPassword + userName);
                    }
                    newOperator.setPassword(userPassword);
                    newOperator.setEnabled(userEnabled);
                    try {
                        operatorHome.create(newOperator);
                        apiResponseMessage = new ApiResponseMessage(4, "User " + userName + " created", false);
                    }
                    catch (Exception e) {
                        apiResponseMessage = new ApiResponseMessage(1, e.getMessage(), false);
                    }
                } else {
                    apiResponseMessage = new ApiResponseMessage(1, "User " + userName + " already created", false);
                }
            }
        } else {
            String sendCommandResult;
            try {
                sendCommandResult = this.processCommand(commandRequest.getUserName(), commandRequest.getCommandToProcess());
            }
            catch (Exception e) {
                return Response.serverError().entity((Object)new ApiResponseMessage(1, e.getMessage(), false)).build();
            }
            apiResponseMessage = sendCommandResult == null ? new ApiResponseMessage(2, "Invalid command: " + commandRequest.getCommandToProcess(), this.determineIfWidget(commandRequest.getCommandToProcess())) : new ApiResponseMessage(4, sendCommandResult, this.determineIfWidget(commandRequest.getCommandToProcess()));
        }
        return Response.ok().entity((Object)apiResponseMessage).build();
    }

    private boolean determineIfWidget(String commandName) {
        return commandName != null && this.widgetCommands.contains(commandName);
    }

    private boolean doLogin(String userId) {
        log.info("[doLogin] Por iniciar una instancia para el usuario [{}]", (Object)userId);
        String initInstanceResult = this.ms.initInstance(userId);
        log.info("[doLogin] Resultado de iniciacion de instancia [{}]", (Object)initInstanceResult);
        this.processCommand(userId, "set ITEMSXPAGE 4000000");
        this.processCommand(userId, "set PATH_DB data");
        this.processCommand(userId, "set PATH_SC scripts");
        this.processCommand(userId, "set PATH_LG log");
        this.processCommand(userId, "set prompt 6");
        return true;
    }

    private String processCommand(String userId, String command) {
        log.info("[processCommand] Por procesar comando [{}] para el usuario [{}]", (Object)command, (Object)userId);
        String result = this.ms.sendCommand(userId, command);
        log.info("[processCommand] Resultado [{}]", (Object)result);
        return result;
    }
}

