/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.csrf;

import ar.com.sdd.marketsim.csrf.AntiCSRFTokenGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntiCSRFTokenManager {
    private static final Logger log = LogManager.getLogger(AntiCSRFTokenManager.class);
    public static final String CSRFParam = "CSRFToken";
    private boolean validateAnyToken = false;
    private final List<String> tokens;
    private final AntiCSRFTokenGenerator generator = new AntiCSRFTokenGenerator();

    public AntiCSRFTokenManager(int numberOfTokens) {
        this.tokens = new LinkedList<String>();
        if (numberOfTokens == 0) {
            this.validateAnyToken = true;
            numberOfTokens = 1;
        }
        for (int i = 1; i < numberOfTokens; ++i) {
            this.tokens.add(this.generator.generateToken());
        }
    }

    public String getToken() {
        Random random = new Random();
        int element = random.nextInt(this.tokens.size());
        return this.tokens.get(element);
    }

    public void validateToken(String token) {
        if (!this.isValidToken(token)) {
            SecurityException se = new SecurityException("Invalid CSRF token");
            log.warn("Invalid CSRF token: {}", (Object)token, (Object)se);
            throw se;
        }
        this.deleteToken(token);
        this.addToken(this.generator.recicleToken(token));
    }

    public void checkToken(String token) {
        if (!this.isValidToken(token)) {
            SecurityException e = new SecurityException("Invalid CSRF token");
            log.warn("Invalid CSRF token: {}", (Object)token, (Object)e);
            throw e;
        }
    }

    public static void clean(HttpSession session) {
        if (session.getAttribute(CSRFParam) != null) {
            session.removeAttribute(CSRFParam);
        }
    }

    public boolean isValidToken(String token) {
        return this.validateAnyToken || this.tokens.contains(token);
    }

    public void deleteToken(String token) {
        this.tokens.remove(token);
    }

    public void addToken(String token) {
        this.tokens.add(token);
    }

    public void addTokens(AntiCSRFTokenManager otherTokenManager) {
        this.tokens.addAll(otherTokenManager.tokens);
    }
}

