/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.server.db;

import ar.com.sdd.marketsim.server.db.DatabaseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Stateless
public class DatabaseUtilBean
implements DatabaseUtil {
    private static final Logger log = LogManager.getLogger(DatabaseUtilBean.class);
    @Resource(name="jdbc/DatabaseUtilDs", mappedName="java:jboss/datasources/marketsimDS")
    private DataSource databaseUtil;

    @Override
    public String getSessionUsername() throws Exception {
        return this.getSessionUsernameAndHost(true);
    }

    @Override
    public String getSessionUsernameAndHost() throws Exception {
        return this.getSessionUsernameAndHost(false);
    }

    private String getSessionUsernameAndHost(boolean onlyUsername) throws Exception {
        String result = "";
        Object query = "SELECT ";
        query = onlyUsername ? (String)query + " user " : (String)query + "user||'@'||host_name ";
        query = (String)query + " FROM v$instance";
        try (Connection conn = this.databaseUtil.getConnection();
             PreparedStatement stmt = conn.prepareStatement((String)query);){
            ResultSet rs = stmt.executeQuery((String)query);
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (Exception ex) {
            log.error("Ha ocurrido un error", (Throwable)ex);
            throw new EJBException(ex);
        }
        return result;
    }
}

