/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.session;

import ar.com.sdd.marketsim.bo.operator.Operator;
import ar.com.sdd.marketsim.csrf.AntiCSRFTokenManager;
import ar.com.sdd.marketsim.session.APPSessionManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class APPSession {
    public static final String APP_SESSION_ATTRIBUTE_NAME = "app.session.id";
    private Operator operator;
    HttpSession httpSession;
    private String remoteAddress;
    private AntiCSRFTokenManager antiCSRFTokenManager;
    private long refreshSerialNumber;
    private static AntiCSRFTokenManager antiCSRFTokenManagerNoSession;

    public APPSession(Operator operator, HttpServletRequest request) {
        this.operator = operator;
        if (request != null) {
            this.httpSession = request.getSession();
        }
    }

    public static APPSession getFrom(PageContext pageContext) {
        return APPSession.getFrom(pageContext.getSession());
    }

    public static APPSession getFrom(HttpServletRequest request) {
        return APPSession.getFrom(request.getSession());
    }

    public static APPSession getFrom(HttpSession session) {
        if (session == null) {
            return null;
        }
        APPSession appSession = (APPSession)session.getAttribute(APP_SESSION_ATTRIBUTE_NAME);
        if (appSession != null && appSession.isRefreshNeeded()) {
            appSession.invalidatePreloadedData();
        }
        return appSession;
    }

    public boolean isRefreshNeeded() {
        return this.getRefreshSerialNumber() < APPSessionManager.getCurrentRefreshSerialNumber();
    }

    public long getRefreshSerialNumber() {
        return this.refreshSerialNumber;
    }

    public void updateRefreshSerialNumber() {
        this.refreshSerialNumber = APPSessionManager.getCurrentRefreshSerialNumber();
    }

    public void invalidatePreloadedData() {
        this.updateRefreshSerialNumber();
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public AntiCSRFTokenManager getAntiCSRFTokenManager() {
        if (this.antiCSRFTokenManager == null) {
            this.antiCSRFTokenManager = new AntiCSRFTokenManager(20);
            if (antiCSRFTokenManagerNoSession != null) {
                this.antiCSRFTokenManager.addTokens(antiCSRFTokenManagerNoSession);
            }
        }
        return this.antiCSRFTokenManager;
    }

    public static AntiCSRFTokenManager getAntiCSRFTokenManagerNoSession() {
        if (antiCSRFTokenManagerNoSession == null) {
            antiCSRFTokenManagerNoSession = new AntiCSRFTokenManager(20);
        }
        return antiCSRFTokenManagerNoSession;
    }

    public static enum SessionRequirement {
        TRUE,
        FALSE,
        REQUIRESNEW;


        public static SessionRequirement parseString(String sessionRequirement) {
            if (sessionRequirement != null) {
                if (sessionRequirement.equalsIgnoreCase("true")) {
                    return TRUE;
                }
                if (sessionRequirement.equalsIgnoreCase("false")) {
                    return FALSE;
                }
                if (sessionRequirement.equalsIgnoreCase("requiresnew")) {
                    return REQUIRESNEW;
                }
            }
            return null;
        }
    }
}

