/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.marketsim.session.http;

import ar.com.sdd.marketsim.util.RandomGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class HTTPSessionManager {
    public void invalidateHTTPSession(HttpSession session, HttpServletRequest request, HttpServletResponse response) {
        HTTPSessionManager.resetSessionId(session, request, response);
        session.invalidate();
    }

    public void invalidateHTTPSession(PageContext pageContext) {
        HttpSession session = pageContext.getSession();
        HTTPSessionManager.resetSessionId(pageContext);
        session.invalidate();
    }

    public static void resetSessionId(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        HttpSession session = pageContext.getSession();
        HTTPSessionManager.resetSessionId(session, request, response);
    }

    public static void resetSessionId(HttpSession session, HttpServletRequest request, HttpServletResponse response) {
        RandomGenerator randomGenerator = new RandomGenerator();
        String sessionid = randomGenerator.generateId(session.getId().length() / 2);
        response.addHeader("SET-COOKIE", "JSESSIONID=" + sessionid + "; Path=" + request.getContextPath() + "; Secure; HttpOnly");
        response.addHeader("SET-COOKIE", "JSESSIONID=; Path=/;  Secure; HttpOnly");
        response.addHeader("SET-COOKIE", "DWRSESSIONID=" + sessionid + "; Path=" + request.getContextPath() + "; Secure; HttpOnly");
        response.addHeader("SET-COOKIE", "DWRSESSIONID=; Path=/;  Secure; HttpOnly");
        request.changeSessionId();
    }
}

